/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DispatchEventCommand
implements Command<Void> {
    protected FlowableEvent event;

    public DispatchEventCommand(FlowableEvent event) {
        this.event = event;
    }

    public Void execute(CommandContext commandContext) {
        if (this.event == null) {
            throw new FlowableIllegalArgumentException("The event to be dispatched must not be null.");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        FlowableEventDispatcher eventDispatcher = cmmnEngineConfiguration.getEventDispatcher();
        if (eventDispatcher == null || !eventDispatcher.isEnabled()) {
            throw new FlowableException("Message dispatcher is disabled, cannot dispatch event.");
        }
        eventDispatcher.dispatchEvent(this.event, cmmnEngineConfiguration.getEngineCfgKey());
        return null;
    }
}

