/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Objects;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.impl.cmd.AbstractCaseStartEventSubscriptionCmd;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceStartEventSubscriptionModificationBuilderImpl;
import org.flowable.cmmn.model.Case;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ModifyCaseInstanceStartEventSubscriptionCmd
extends AbstractCaseStartEventSubscriptionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final CaseInstanceStartEventSubscriptionModificationBuilderImpl builder;

    public ModifyCaseInstanceStartEventSubscriptionCmd(CaseInstanceStartEventSubscriptionModificationBuilderImpl builder) {
        this.builder = builder;
    }

    public Void execute(CommandContext commandContext) {
        CaseDefinition newCaseDefinition;
        if (this.builder.hasNewCaseDefinitionId()) {
            newCaseDefinition = this.getCaseDefinitionById(this.builder.getNewCaseDefinitionId(), commandContext);
        } else {
            CaseDefinition caseDefinition = this.getCaseDefinitionById(this.builder.getCaseDefinitionId(), commandContext);
            newCaseDefinition = this.getLatestCaseDefinitionByKey(caseDefinition.getKey(), caseDefinition.getTenantId(), commandContext);
        }
        if (newCaseDefinition == null) {
            throw new FlowableIllegalArgumentException("Cannot find case definition with id " + (this.builder.hasNewCaseDefinitionId() ? this.builder.getNewCaseDefinitionId() : this.builder.getCaseDefinitionId()));
        }
        Case caze = this.getCase(newCaseDefinition.getId(), commandContext);
        String eventDefinitionKey = caze.getStartEventType();
        String startCorrelationConfiguration = this.getStartCorrelationConfiguration(newCaseDefinition.getId(), commandContext);
        if (eventDefinitionKey != null && Objects.equals(startCorrelationConfiguration, "manualSubscription")) {
            String correlationKey = null;
            if (this.builder.hasCorrelationParameterValues()) {
                correlationKey = this.generateCorrelationConfiguration(eventDefinitionKey, this.builder.getTenantId(), this.builder.getCorrelationParameterValues(), commandContext);
            }
            this.getEventSubscriptionService(commandContext).updateEventSubscriptionScopeDefinitionId(this.builder.getCaseDefinitionId(), newCaseDefinition.getId(), eventDefinitionKey, null, correlationKey);
        }
        return null;
    }
}

