/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.migration;

import org.flowable.batch.api.Batch;
import org.flowable.cmmn.api.CmmnMigrationService;
import org.flowable.cmmn.api.migration.HistoricCaseInstanceMigrationBuilder;
import org.flowable.cmmn.api.migration.HistoricCaseInstanceMigrationDocument;
import org.flowable.cmmn.engine.impl.migration.HistoricCaseInstanceMigrationDocumentBuilderImpl;
import org.flowable.common.engine.api.FlowableException;

public class HistoricCaseInstanceMigrationBuilderImpl
implements HistoricCaseInstanceMigrationBuilder {
    protected CmmnMigrationService cmmnMigrationService;
    protected HistoricCaseInstanceMigrationDocumentBuilderImpl historicCaseInstanceMigrationDocumentDocumentBuilder = new HistoricCaseInstanceMigrationDocumentBuilderImpl();

    public HistoricCaseInstanceMigrationBuilderImpl(CmmnMigrationService cmmnMigrationService) {
        this.cmmnMigrationService = cmmnMigrationService;
    }

    public HistoricCaseInstanceMigrationBuilder fromHistoricCaseInstanceMigrationDocument(HistoricCaseInstanceMigrationDocument caseInstanceMigrationDocument) {
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseInstanceMigrationDocument.getMigrateToCaseDefinitionId());
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseInstanceMigrationDocument.getMigrateToCaseDefinitionKey(), caseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion());
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setTenantId(caseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId());
        return this;
    }

    public HistoricCaseInstanceMigrationBuilder migrateToCaseDefinition(String caseDefinitionId) {
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionId);
        return this;
    }

    public HistoricCaseInstanceMigrationBuilder migrateToCaseDefinition(String caseDefinitionKey, int caseDefinitionVersion) {
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionKey, caseDefinitionVersion);
        return this;
    }

    public HistoricCaseInstanceMigrationBuilder migrateToCaseDefinition(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId) {
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionKey, caseDefinitionVersion);
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setTenantId(caseDefinitionTenantId);
        return this;
    }

    public HistoricCaseInstanceMigrationBuilder withMigrateToCaseDefinitionTenantId(String caseDefinitionTenantId) {
        this.historicCaseInstanceMigrationDocumentDocumentBuilder.setTenantId(caseDefinitionTenantId);
        return this;
    }

    public HistoricCaseInstanceMigrationDocument getHistoricCaseInstanceMigrationDocument() {
        return this.historicCaseInstanceMigrationDocumentDocumentBuilder.build();
    }

    public void migrate(String caseInstanceId) {
        this.getCmmnMigrationService().migrateHistoricCaseInstance(caseInstanceId, this.getHistoricCaseInstanceMigrationDocument());
    }

    public void migrateHistoricCaseInstances(String caseDefinitionId) {
        this.getCmmnMigrationService().migrateHistoricCaseInstancesOfCaseDefinition(caseDefinitionId, this.getHistoricCaseInstanceMigrationDocument());
    }

    public Batch batchMigrateHistoricCaseInstances(String caseDefinitionId) {
        return this.getCmmnMigrationService().batchMigrateHistoricCaseInstancesOfCaseDefinition(caseDefinitionId, this.getHistoricCaseInstanceMigrationDocument());
    }

    public void migrateHistoricCaseInstances(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId) {
        this.getCmmnMigrationService().migrateHistoricCaseInstancesOfCaseDefinition(caseDefinitionKey, caseDefinitionVersion, caseDefinitionTenantId, this.getHistoricCaseInstanceMigrationDocument());
    }

    public Batch batchMigrateHistoricCaseInstances(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId) {
        return this.getCmmnMigrationService().batchMigrateHistoricCaseInstancesOfCaseDefinition(caseDefinitionKey, caseDefinitionVersion, caseDefinitionTenantId, this.getHistoricCaseInstanceMigrationDocument());
    }

    protected CmmnMigrationService getCmmnMigrationService() {
        if (this.cmmnMigrationService == null) {
            throw new FlowableException("CaseMigrationService cannot be null, Obtain your builder instance from the CaseMigrationService to access this feature");
        }
        return this.cmmnMigrationService;
    }
}

