/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.exception;

import java.util.UUID;
import org.flowable.common.engine.api.FlowableForbiddenException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.FlowableTaskAlreadyClaimedException;
import org.flowable.common.rest.exception.ErrorInfo;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.common.rest.exception.FlowableContentNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class BaseExceptionHandlerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseExceptionHandlerAdvice.class);
    protected boolean sendFullErrorException = true;

    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    @ExceptionHandler(value={FlowableContentNotSupportedException.class})
    @ResponseBody
    public ErrorInfo handleNotSupported(FlowableContentNotSupportedException e) {
        return new ErrorInfo("Content is not supported", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={FlowableConflictException.class})
    @ResponseBody
    public ErrorInfo handleConflict(FlowableConflictException e) {
        return new ErrorInfo("Conflict", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={FlowableObjectNotFoundException.class})
    @ResponseBody
    public ErrorInfo handleNotFound(FlowableObjectNotFoundException e) {
        return new ErrorInfo("Not found", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={FlowableForbiddenException.class})
    @ResponseBody
    public ErrorInfo handleForbidden(FlowableForbiddenException e) {
        return new ErrorInfo("Forbidden", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={FlowableIllegalArgumentException.class})
    @ResponseBody
    public ErrorInfo handleIllegalArgument(FlowableIllegalArgumentException e) {
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={FlowableIllegalStateException.class})
    @ResponseBody
    public ErrorInfo handleIllegalState(FlowableIllegalStateException e) {
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseBody
    public ErrorInfo handleBadMessageConversion(HttpMessageConversionException e) {
        if (this.sendFullErrorException) {
            return new ErrorInfo("Bad request", (Exception)e);
        }
        String errorIdentifier = UUID.randomUUID().toString();
        LOGGER.warn("Invalid Message conversion exception. Error ID: {}", (Object)errorIdentifier, (Object)e);
        ErrorInfo errorInfo = new ErrorInfo("Bad request", null);
        errorInfo.setException("Invalid HTTP message. Error ID: " + errorIdentifier);
        return errorInfo;
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={FlowableTaskAlreadyClaimedException.class})
    @ResponseBody
    public ErrorInfo handleTaskAlreadyClaimed(FlowableTaskAlreadyClaimedException e) {
        return new ErrorInfo("Task was already claimed", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorInfo handleOtherException(Exception e) {
        if (this.sendFullErrorException) {
            LOGGER.error("Unhandled exception", (Throwable)e);
            return new ErrorInfo("Internal server error", e);
        }
        String errorIdentifier = UUID.randomUUID().toString();
        LOGGER.error("Unhandled exception. Error ID: {}", (Object)errorIdentifier, (Object)e);
        ErrorInfo errorInfo = new ErrorInfo("Internal server error", e);
        errorInfo.setException("Error with ID: " + errorIdentifier);
        return errorInfo;
    }

    public boolean isSendFullErrorException() {
        return this.sendFullErrorException;
    }

    public void setSendFullErrorException(boolean sendFullErrorException) {
        this.sendFullErrorException = sendFullErrorException;
    }
}

