/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.rest.service.api.repository.BaseDecisionTableResource;
import org.flowable.dmn.rest.service.api.repository.DecisionTableResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Decision Tables"}, description="Manage Decision Tables", authorizations={@Authorization(value="basicAuth")})
public class DecisionTableResource
extends BaseDecisionTableResource {
    @ApiOperation(value="Get a decision table", tags={"Decision Tables"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the decision table is returned"), @ApiResponse(code=404, message="Indicates the requested decision table was not found.")})
    @GetMapping(value={"/dmn-repository/decision-tables/{decisionTableId}"}, produces={"application/json"})
    public DecisionTableResponse getDecisionTable(@ApiParam(name="decisionTableId") @PathVariable String decisionTableId, HttpServletRequest request) {
        DmnDecisionTable decisionTable = this.getDecisionTableFromRequest(decisionTableId);
        return this.dmnRestResponseFactory.createDecisionTableResponse(decisionTable);
    }
}

