/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.rest.service.api.repository.BaseDecisionResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Decision"}, description="Manage Decisions", authorizations={@Authorization(value="basicAuth")})
public class DecisionImageResource
extends BaseDecisionResource {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="Get a decision requirements diagram image", tags={"Decisions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the decision requirements diagram image returned"), @ApiResponse(code=404, message="Indicates the requested decision requirements diagram image was not found.")})
    @GetMapping(value={"/dmn-repository/decisions/{decisionId}/image"}, produces={"image/png"})
    public ResponseEntity<byte[]> getImageResource(@ApiParam(name="decisionId") @PathVariable String decisionId) {
        DmnDecision decision = this.getDecisionFromRequest(decisionId);
        try (InputStream imageStream = this.dmnRepositoryService.getDecisionRequirementsDiagram(decision.getId());){
            if (imageStream == null) throw new FlowableObjectNotFoundException("Decision with id '" + decision.getId() + "' has no image.");
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", "image/png");
            try {
                ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)imageStream), (MultiValueMap)responseHeaders, HttpStatus.OK);
                return responseEntity;
            }
            catch (Exception e) {
                throw new FlowableException("Error reading image stream", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new FlowableException("Error reading image stream", (Throwable)e);
        }
    }
}

