/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.flowable.dmn.rest.service.api.repository.DmnDeploymentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Deployment"}, description="Manage Decision Deployments", authorizations={@Authorization(value="basicAuth")})
public class DmnDeploymentResource {
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get a decision deployment", tags={"Deployment"}, nickname="getDecisionDeployment")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the deployment was found and returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @GetMapping(value={"/dmn-repository/deployments/{deploymentId}"}, produces={"application/json"})
    public DmnDeploymentResponse getDmnDeployment(@ApiParam(name="deploymentId") @PathVariable String deploymentId) {
        DmnDeployment deployment = (DmnDeployment)this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a DMN deployment with id '" + deploymentId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        return this.dmnRestResponseFactory.createDmnDeploymentResponse(deployment);
    }

    @ApiOperation(value="Delete a decision deployment", tags={"Deployment"}, nickname="deleteDecisionDeployment")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the deployment was found and has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @DeleteMapping(value={"/dmn-repository/deployments/{deploymentId}"}, produces={"application/json"})
    public void deleteDmnDeployment(@ApiParam(name="deploymentId") @PathVariable String deploymentId, HttpServletResponse response) {
        DmnDeployment deployment = (DmnDeployment)this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a DMN deployment with id '" + deploymentId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteDeployment(deployment);
        }
        this.dmnRepositoryService.deleteDeployment(deploymentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

