/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Transaction;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ParallelMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public ParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution multiInstanceRootExecution) {
        ExecutionEntity concurrentExecution;
        int loopCounter;
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceRootExecution);
        if (nrOfInstances < 0) {
            throw new FlowableIllegalArgumentException("Invalid number of instances: must be non-negative integer value, but was " + nrOfInstances);
        }
        this.setLoopVariable(multiInstanceRootExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ExecutionEntity> concurrentExecutions = new ArrayList<ExecutionEntity>();
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceRootExecution);
            concurrentExecution.setCurrentFlowElement((FlowElement)this.activity);
            concurrentExecution.setActive(true);
            concurrentExecution.setScope(false);
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = (ExecutionEntity)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || concurrentExecution.getParent().isEnded()) continue;
            this.executeOriginalBehavior(concurrentExecution, (ExecutionEntity)multiInstanceRootExecution, loopCounter);
        }
        if (!concurrentExecutions.isEmpty()) {
            multiInstanceRootExecution.setActive(false);
        }
        return nrOfInstances;
    }

    @Override
    public void leave(DelegateExecution execution) {
        boolean zeroNrOfInstances = false;
        if (this.resolveNrOfInstances(execution) == 0) {
            zeroNrOfInstances = true;
            super.leave(execution);
        }
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        DelegateExecution miRootExecution = this.getMultiInstanceRootExecution(execution);
        if (miRootExecution != null) {
            this.setLoopVariable(miRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
            this.setLoopVariable(miRootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        }
        CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd((ExecutionEntity)execution, null);
        this.callActivityEndListeners(execution);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        if (zeroNrOfInstances) {
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (executionEntity.getParent() != null) {
            executionEntity.inactivate();
            this.lockFirstParentScope(executionEntity);
            boolean isCompletionConditionSatisfied = this.completionConditionSatisfied(execution.getParent());
            if (nrOfCompletedInstances >= nrOfInstances || isCompletionConditionSatisfied) {
                ExecutionEntity leavingExecution = null;
                if (nrOfInstances > 0) {
                    leavingExecution = executionEntity.getParent();
                } else {
                    CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd((ExecutionEntity)execution, null);
                    leavingExecution = executionEntity;
                }
                Activity activity = (Activity)execution.getCurrentFlowElement();
                this.verifyCompensation(execution, leavingExecution, activity);
                this.verifyCallActivity(leavingExecution, activity);
                if (isCompletionConditionSatisfied) {
                    LinkedList<? extends DelegateExecution> toVerify = new LinkedList<DelegateExecution>(miRootExecution.getExecutions());
                    while (!toVerify.isEmpty()) {
                        List<? extends DelegateExecution> childExecutions;
                        DelegateExecution childExecution = toVerify.pop();
                        if (((ExecutionEntity)childExecution).isInserted()) {
                            childExecution.inactivate();
                        }
                        if ((childExecutions = childExecution.getExecutions()) == null || childExecutions.isEmpty()) continue;
                        toVerify.addAll(childExecutions);
                    }
                    this.sendCompletedWithConditionEvent(leavingExecution);
                } else {
                    this.sendCompletedEvent(leavingExecution);
                }
                super.leave(leavingExecution);
            }
        } else {
            this.sendCompletedEvent(execution);
            super.leave(execution);
        }
    }

    protected Activity verifyCompensation(DelegateExecution execution, ExecutionEntity executionToUse, Activity activity) {
        boolean hasCompensation = false;
        if (activity instanceof Transaction) {
            hasCompensation = true;
        } else if (activity instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)activity;
            block0: for (FlowElement subElement : subProcess.getFlowElements()) {
                Activity subActivity;
                if (!(subElement instanceof Activity) || !CollectionUtil.isNotEmpty((Collection)(subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                    if (!CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                    hasCompensation = true;
                    continue block0;
                }
            }
        }
        if (hasCompensation) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(executionToUse);
        }
        return activity;
    }

    protected void verifyCallActivity(ExecutionEntity executionToUse, Activity activity) {
        if (activity instanceof CallActivity) {
            ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
            if (executionToUse != null) {
                ArrayList<String> callActivityExecutionIds = new ArrayList<String>();
                List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(executionToUse);
                if (childExecutions != null) {
                    for (ExecutionEntity childExecution : childExecutions) {
                        if (!activity.getId().equals(childExecution.getCurrentActivityId())) continue;
                        callActivityExecutionIds.add(childExecution.getId());
                    }
                    for (int i = childExecutions.size() - 1; i >= 0; --i) {
                        ExecutionEntity childExecution;
                        childExecution = childExecutions.get(i);
                        if (!StringUtils.isNotEmpty((CharSequence)childExecution.getSuperExecutionId()) || !callActivityExecutionIds.contains(childExecution.getSuperExecutionId())) continue;
                        executionEntityManager.deleteProcessInstanceExecutionEntity(childExecution.getId(), activity.getId(), "call activity completion condition met", true, false, true);
                    }
                }
            }
        }
    }

    protected void lockFirstParentScope(DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager();
        boolean found = false;
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentExecution = (ExecutionEntity)execution;
        while (!found && currentExecution != null && currentExecution.getParentId() != null) {
            parentScopeExecution = (ExecutionEntity)executionEntityManager.findById(currentExecution.getParentId());
            if (parentScopeExecution != null && parentScopeExecution.isScope()) {
                found = true;
            }
            currentExecution = parentScopeExecution;
        }
        parentScopeExecution.forceUpdate();
    }
}

