/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.listener;

import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.cfg.TransactionListener;
import org.flowable.common.engine.impl.cfg.TransactionState;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.engine.delegate.BaseExecutionListener;
import org.flowable.engine.delegate.CustomPropertiesResolver;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.delegate.TransactionDependentExecutionListener;
import org.flowable.engine.delegate.TransactionDependentTaskListener;
import org.flowable.engine.impl.bpmn.listener.ExecuteExecutionListenerTransactionListener;
import org.flowable.engine.impl.bpmn.listener.ExecuteTaskListenerTransactionListener;
import org.flowable.engine.impl.bpmn.listener.TransactionDependentExecutionListenerExecutionScope;
import org.flowable.engine.impl.bpmn.listener.TransactionDependentTaskListenerExecutionScope;
import org.flowable.engine.impl.bpmn.parser.factory.ListenerFactory;
import org.flowable.engine.impl.delegate.invocation.TaskListenerInvocation;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ExecutionHelper;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.service.delegate.BaseTaskListener;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class ListenerNotificationHelper {
    public void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, DelegateExecution execution, String eventType) {
        List listeners = elementWithExecutionListeners.getExecutionListeners();
        if (listeners != null && listeners.size() > 0) {
            ListenerFactory listenerFactory = CommandContextUtil.getProcessEngineConfiguration().getListenerFactory();
            for (FlowableListener listener : listeners) {
                if (!eventType.equals(listener.getEvent())) continue;
                BaseExecutionListener executionListener = null;
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(listener.getImplementationType())) {
                    executionListener = listenerFactory.createClassDelegateExecutionListener(listener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(listener.getImplementationType())) {
                    executionListener = listenerFactory.createExpressionExecutionListener(listener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(listener.getImplementationType())) {
                    executionListener = listener.getOnTransaction() != null ? listenerFactory.createTransactionDependentDelegateExpressionExecutionListener(listener) : listenerFactory.createDelegateExpressionExecutionListener(listener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_INSTANCE.equalsIgnoreCase(listener.getImplementationType())) {
                    executionListener = (ExecutionListener)listener.getInstance();
                }
                if (executionListener == null) continue;
                if (listener.getOnTransaction() != null) {
                    this.planTransactionDependentExecutionListener(listenerFactory, execution, (TransactionDependentExecutionListener)executionListener, listener);
                    continue;
                }
                execution.setEventName(eventType);
                execution.setCurrentFlowableListener(listener);
                executionListener.notify(execution);
                execution.setEventName(null);
                execution.setCurrentFlowableListener(null);
            }
        }
    }

    protected void planTransactionDependentExecutionListener(ListenerFactory listenerFactory, DelegateExecution execution, TransactionDependentExecutionListener executionListener, FlowableListener listener) {
        Map executionVariablesToUse = execution.getVariables();
        CustomPropertiesResolver customPropertiesResolver = this.createCustomPropertiesResolver(listener);
        Map<String, Object> customPropertiesMapToUse = this.invokeCustomPropertiesResolver(execution, customPropertiesResolver);
        TransactionDependentExecutionListenerExecutionScope scope = new TransactionDependentExecutionListenerExecutionScope(execution.getProcessInstanceId(), execution.getId(), execution.getCurrentFlowElement(), executionVariablesToUse, customPropertiesMapToUse);
        this.addTransactionListener(listener, new ExecuteExecutionListenerTransactionListener(executionListener, scope, CommandContextUtil.getProcessEngineConfiguration().getCommandExecutor()));
    }

    public void executeTaskListeners(TaskEntity taskEntity, String eventType) {
        Process process;
        FlowElement flowElement;
        if (taskEntity.getProcessDefinitionId() != null && (flowElement = (process = ProcessDefinitionUtil.getProcess(taskEntity.getProcessDefinitionId())).getFlowElement(taskEntity.getTaskDefinitionKey(), true)) instanceof UserTask) {
            UserTask userTask = (UserTask)flowElement;
            this.executeTaskListeners(userTask, taskEntity, eventType);
        }
    }

    public void executeTaskListeners(UserTask userTask, TaskEntity taskEntity, String eventType) {
        for (FlowableListener listener : userTask.getTaskListeners()) {
            String event = listener.getEvent();
            if (!event.equals(eventType) && !event.equals("all")) continue;
            BaseTaskListener taskListener = this.createTaskListener(listener);
            if (listener.getOnTransaction() != null) {
                this.planTransactionDependentTaskListener(ExecutionHelper.getExecution(taskEntity.getExecutionId()), (TransactionDependentTaskListener)taskListener, listener);
                continue;
            }
            taskEntity.setEventName(eventType);
            taskEntity.setEventHandlerId(listener.getId());
            try {
                CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)taskListener, (DelegateTask)taskEntity));
            }
            catch (Exception e) {
                throw new FlowableException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
            }
            finally {
                taskEntity.setEventName(null);
            }
        }
    }

    protected BaseTaskListener createTaskListener(FlowableListener listener) {
        Object taskListener = null;
        ListenerFactory listenerFactory = CommandContextUtil.getProcessEngineConfiguration().getListenerFactory();
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createClassDelegateTaskListener(listener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createExpressionTaskListener(listener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listener.getOnTransaction() != null ? listenerFactory.createTransactionDependentDelegateExpressionTaskListener(listener) : listenerFactory.createDelegateExpressionTaskListener(listener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_INSTANCE.equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = (TaskListener)listener.getInstance();
        }
        return taskListener;
    }

    protected void planTransactionDependentTaskListener(DelegateExecution execution, TransactionDependentTaskListener taskListener, FlowableListener listener) {
        Map executionVariablesToUse = execution.getVariables();
        CustomPropertiesResolver customPropertiesResolver = this.createCustomPropertiesResolver(listener);
        Map<String, Object> customPropertiesMapToUse = this.invokeCustomPropertiesResolver(execution, customPropertiesResolver);
        TransactionDependentTaskListenerExecutionScope scope = new TransactionDependentTaskListenerExecutionScope(execution.getProcessInstanceId(), execution.getId(), (Task)execution.getCurrentFlowElement(), executionVariablesToUse, customPropertiesMapToUse);
        this.addTransactionListener(listener, new ExecuteTaskListenerTransactionListener(taskListener, scope, CommandContextUtil.getProcessEngineConfiguration().getCommandExecutor()));
    }

    protected CustomPropertiesResolver createCustomPropertiesResolver(FlowableListener listener) {
        CustomPropertiesResolver customPropertiesResolver = null;
        ListenerFactory listenerFactory = CommandContextUtil.getProcessEngineConfiguration().getListenerFactory();
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(listener.getCustomPropertiesResolverImplementationType())) {
            customPropertiesResolver = listenerFactory.createClassDelegateCustomPropertiesResolver(listener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(listener.getCustomPropertiesResolverImplementationType())) {
            customPropertiesResolver = listenerFactory.createExpressionCustomPropertiesResolver(listener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(listener.getCustomPropertiesResolverImplementationType())) {
            customPropertiesResolver = listenerFactory.createDelegateExpressionCustomPropertiesResolver(listener);
        }
        return customPropertiesResolver;
    }

    protected Map<String, Object> invokeCustomPropertiesResolver(DelegateExecution execution, CustomPropertiesResolver customPropertiesResolver) {
        Map<String, Object> customPropertiesMapToUse = null;
        if (customPropertiesResolver != null) {
            customPropertiesMapToUse = customPropertiesResolver.getCustomPropertiesMap(execution);
        }
        return customPropertiesMapToUse;
    }

    protected void addTransactionListener(FlowableListener listener, TransactionListener transactionListener) {
        TransactionContext transactionContext = Context.getTransactionContext();
        if ("before-commit".equals(listener.getOnTransaction())) {
            transactionContext.addTransactionListener(TransactionState.COMMITTING, transactionListener);
        } else if ("committed".equals(listener.getOnTransaction())) {
            transactionContext.addTransactionListener(TransactionState.COMMITTED, transactionListener);
        } else if ("rolled-back".equals(listener.getOnTransaction())) {
            transactionContext.addTransactionListener(TransactionState.ROLLED_BACK, transactionListener);
        }
    }
}

