/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.dynamic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.io.BytesStreamSource;
import org.flowable.engine.impl.dynamic.BaseDynamicSubProcessInjectUtil;
import org.flowable.engine.impl.dynamic.DynamicEmbeddedSubProcessBuilder;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class DynamicSubProcessParallelInjectUtil
extends BaseDynamicSubProcessInjectUtil {
    public static void injectParallelSubProcess(Process process, BpmnModel bpmnModel, DynamicEmbeddedSubProcessBuilder dynamicEmbeddedSubProcessBuilder, ProcessDefinitionEntity originalProcessDefinitionEntity, DeploymentEntity newDeploymentEntity, CommandContext commandContext) {
        List startEvents = process.findFlowElementsOfType(StartEvent.class);
        StartEvent initialStartEvent = null;
        for (StartEvent startEvent : startEvents) {
            if (startEvent.getEventDefinitions().size() == 0) {
                initialStartEvent = startEvent;
                break;
            }
            if (initialStartEvent != null) continue;
            initialStartEvent = startEvent;
        }
        GraphicInfo elementGraphicInfo = bpmnModel.getGraphicInfo(initialStartEvent.getId());
        ParallelGateway parallelGateway = new ParallelGateway();
        parallelGateway.setId(dynamicEmbeddedSubProcessBuilder.nextForkGatewayId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)parallelGateway);
        SubProcess subProcess = new SubProcess();
        if (dynamicEmbeddedSubProcessBuilder.getId() != null) {
            subProcess.setId(dynamicEmbeddedSubProcessBuilder.getId());
        } else {
            subProcess.setId(dynamicEmbeddedSubProcessBuilder.nextSubProcessId(process.getFlowElementMap()));
        }
        dynamicEmbeddedSubProcessBuilder.setDynamicSubProcessId(subProcess.getId());
        ProcessDefinition subProcessDefinition = ProcessDefinitionUtil.getProcessDefinition(dynamicEmbeddedSubProcessBuilder.getProcessDefinitionId());
        ResourceEntity subProcessBpmnResource = CommandContextUtil.getResourceEntityManager(commandContext).findResourceByDeploymentIdAndResourceName(subProcessDefinition.getDeploymentId(), subProcessDefinition.getResourceName());
        BpmnModel bpmnModelSubProcess = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new BytesStreamSource(subProcessBpmnResource.getBytes()), false, false);
        for (Object flowElement : bpmnModelSubProcess.getMainProcess().getFlowElements()) {
            subProcess.addFlowElement((FlowElement)flowElement);
        }
        DynamicSubProcessParallelInjectUtil.processFlowElements(commandContext, (FlowElementsContainer)process, bpmnModel, originalProcessDefinitionEntity, newDeploymentEntity);
        HashMap<String, FlowElement> generatedIds = new HashMap<String, FlowElement>();
        DynamicSubProcessParallelInjectUtil.processSubProcessFlowElements(commandContext, subProcess.getId(), process, bpmnModel, subProcess, bpmnModelSubProcess, subProcessDefinition, newDeploymentEntity, generatedIds, elementGraphicInfo != null);
        for (String originalFlowElementId : generatedIds.keySet()) {
            FlowElement duplicateFlowElement = (FlowElement)generatedIds.get(originalFlowElementId);
            duplicateFlowElement.getParentContainer().removeFlowElementFromMap(originalFlowElementId);
            duplicateFlowElement.getParentContainer().addFlowElementToMap(duplicateFlowElement);
        }
        process.addFlowElement((FlowElement)subProcess);
        EndEvent endEvent = new EndEvent();
        endEvent.setId(dynamicEmbeddedSubProcessBuilder.nextEndEventId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)endEvent);
        SequenceFlow flowToSubProcess = new SequenceFlow(parallelGateway.getId(), subProcess.getId());
        flowToSubProcess.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)flowToSubProcess);
        SequenceFlow flowFromSubProcess = new SequenceFlow(subProcess.getId(), endEvent.getId());
        flowFromSubProcess.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)flowFromSubProcess);
        SequenceFlow initialFlow = (SequenceFlow)initialStartEvent.getOutgoingFlows().get(0);
        initialFlow.setSourceRef(parallelGateway.getId());
        SequenceFlow flowFromStart = new SequenceFlow(initialStartEvent.getId(), parallelGateway.getId());
        flowFromStart.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)flowFromStart);
        if (elementGraphicInfo != null) {
            double yDiff = 0.0;
            double xDiff = 80.0;
            if (elementGraphicInfo.getY() < 173.0) {
                yDiff = 173.0 - elementGraphicInfo.getY();
                elementGraphicInfo.setY(173.0);
            }
            Map locationMap = bpmnModel.getLocationMap();
            for (Object locationId : locationMap.keySet()) {
                if (initialStartEvent.getId().equals(locationId)) continue;
                GraphicInfo locationGraphicInfo = (GraphicInfo)locationMap.get(locationId);
                locationGraphicInfo.setX(locationGraphicInfo.getX() + xDiff);
                locationGraphicInfo.setY(locationGraphicInfo.getY() + yDiff);
            }
            Map flowLocationMap = bpmnModel.getFlowLocationMap();
            for (String flowId : flowLocationMap.keySet()) {
                if (flowFromStart.getId().equals(flowId)) continue;
                List flowGraphicInfoList = (List)flowLocationMap.get(flowId);
                for (GraphicInfo flowGraphicInfo : flowGraphicInfoList) {
                    flowGraphicInfo.setX(flowGraphicInfo.getX() + xDiff);
                    flowGraphicInfo.setY(flowGraphicInfo.getY() + yDiff);
                }
            }
            GraphicInfo forkGraphicInfo = new GraphicInfo(elementGraphicInfo.getX() + 75.0, elementGraphicInfo.getY() - 5.0, 40.0, 40.0);
            bpmnModel.addGraphicInfo(parallelGateway.getId(), forkGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(flowFromStart.getId(), DynamicSubProcessParallelInjectUtil.createWayPoints(elementGraphicInfo.getX() + 30.0, elementGraphicInfo.getY() + 15.0, elementGraphicInfo.getX() + 75.0, elementGraphicInfo.getY() + 15.0));
            GraphicInfo newSubProcessGraphicInfo = new GraphicInfo(elementGraphicInfo.getX() + 185.0, elementGraphicInfo.getY() - 163.0, 80.0, 100.0);
            newSubProcessGraphicInfo.setExpanded(Boolean.valueOf(false));
            bpmnModel.addGraphicInfo(subProcess.getId(), newSubProcessGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(flowToSubProcess.getId(), DynamicSubProcessParallelInjectUtil.createWayPoints(elementGraphicInfo.getX() + 95.0, elementGraphicInfo.getY() - 5.0, elementGraphicInfo.getX() + 95.0, elementGraphicInfo.getY() - 123.0, elementGraphicInfo.getX() + 185.0, elementGraphicInfo.getY() - 123.0));
            GraphicInfo endGraphicInfo = new GraphicInfo(elementGraphicInfo.getX() + 335.0, elementGraphicInfo.getY() - 137.0, 28.0, 28.0);
            bpmnModel.addGraphicInfo(endEvent.getId(), endGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(flowFromSubProcess.getId(), DynamicSubProcessParallelInjectUtil.createWayPoints(elementGraphicInfo.getX() + 285.0, elementGraphicInfo.getY() - 123.0, elementGraphicInfo.getX() + 335.0, elementGraphicInfo.getY() - 123.0));
        }
    }
}

