/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.impl.migration.ProcessInstanceMigrationDocumentBuilderImpl;
import org.flowable.engine.migration.ActivityMigrationMapping;
import org.flowable.engine.migration.ActivityMigrationMappingOptions;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;

public class ProcessInstanceMigrationDocumentConverter {
    protected static Predicate<JsonNode> isNotNullNode = jsonNode -> jsonNode != null && !jsonNode.isNull();
    protected static Predicate<JsonNode> isSingleTextValue = jsonNode -> isNotNullNode.test((JsonNode)jsonNode) && jsonNode.isTextual();
    protected static Predicate<JsonNode> isMultiValue = jsonNode -> isNotNullNode.test((JsonNode)jsonNode) && jsonNode.isArray();
    protected static ObjectMapper objectMapper = new ObjectMapper();
    protected static Map<Class<? extends ActivityMigrationMapping>, BaseActivityMigrationMappingConverter> activityMigrationMappingConverters = new HashMap<Class<? extends ActivityMigrationMapping>, BaseActivityMigrationMappingConverter>();

    protected static <T> T convertFromJsonNodeToObject(JsonNode jsonNode, ObjectMapper objectMapper) {
        return (T)objectMapper.convertValue((Object)jsonNode, new TypeReference<T>(){});
    }

    public static JsonNode convertToJson(ProcessInstanceMigrationDocument processInstanceMigrationDocument) {
        JsonNode processInstanceVariablesNode;
        ArrayNode mappingNodes;
        ObjectNode documentNode = objectMapper.createObjectNode();
        if (processInstanceMigrationDocument.getMigrateToProcessDefinitionId() != null) {
            documentNode.put("toProcessDefinitionId", processInstanceMigrationDocument.getMigrateToProcessDefinitionId());
        }
        if (processInstanceMigrationDocument.getMigrateToProcessDefinitionKey() != null) {
            documentNode.put("toProcessDefinitionKey", processInstanceMigrationDocument.getMigrateToProcessDefinitionKey());
        }
        if (processInstanceMigrationDocument.getMigrateToProcessDefinitionVersion() != null) {
            documentNode.put("toProcessDefinitionVersion", processInstanceMigrationDocument.getMigrateToProcessDefinitionVersion());
        }
        if (processInstanceMigrationDocument.getMigrateToProcessDefinitionTenantId() != null) {
            documentNode.put("toProcessDefinitionTenantId", processInstanceMigrationDocument.getMigrateToProcessDefinitionTenantId());
        }
        if ((mappingNodes = ProcessInstanceMigrationDocumentConverter.convertToJsonActivityMigrationMappings(processInstanceMigrationDocument.getActivityMigrationMappings())) != null && !mappingNodes.isNull()) {
            documentNode.set("activityMappings", (JsonNode)mappingNodes);
        }
        if ((processInstanceVariablesNode = ProcessInstanceMigrationDocumentConverter.convertToJsonProcessInstanceVariables(processInstanceMigrationDocument, objectMapper)) != null && !processInstanceVariablesNode.isNull()) {
            documentNode.set("processInstanceVariables", processInstanceVariablesNode);
        }
        return documentNode;
    }

    public static String convertToJsonString(ProcessInstanceMigrationDocument processInstanceMigrationDocument) {
        JsonNode jsonNode = ProcessInstanceMigrationDocumentConverter.convertToJson(processInstanceMigrationDocument);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        try {
            return objectWriter.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            return jsonNode.toString();
        }
    }

    protected static ArrayNode convertToJsonActivityMigrationMappings(List<? extends ActivityMigrationMapping> activityMigrationMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (ActivityMigrationMapping activityMigrationMapping : activityMigrationMappings) {
            BaseActivityMigrationMappingConverter mappingConverter = activityMigrationMappingConverters.get(activityMigrationMapping.getClass());
            if (mappingConverter == null) {
                throw new FlowableException("Cannot convert mapping of type '" + activityMigrationMapping.getClass() + "'");
            }
            ObjectNode mappingNode = mappingConverter.convertToJson(activityMigrationMapping, objectMapper);
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    public static ProcessInstanceMigrationDocument convertFromJson(String jsonProcessInstanceMigrationDocument) {
        try {
            JsonNode processInstanceVariablesNode;
            JsonNode rootNode = objectMapper.readTree(jsonProcessInstanceMigrationDocument);
            ProcessInstanceMigrationDocumentBuilderImpl documentBuilder = new ProcessInstanceMigrationDocumentBuilderImpl();
            String processDefinitionId = Optional.ofNullable(rootNode.get("toProcessDefinitionId")).map(JsonNode::textValue).orElse(null);
            documentBuilder.setProcessDefinitionToMigrateTo(processDefinitionId);
            String processDefinitionKey = Optional.ofNullable(rootNode.get("toProcessDefinitionKey")).map(JsonNode::textValue).orElse(null);
            Integer processDefinitionVersion = Optional.ofNullable(rootNode.get("toProcessDefinitionVersion")).map(JsonNode::numberValue).orElse(null);
            documentBuilder.setProcessDefinitionToMigrateTo(processDefinitionKey, processDefinitionVersion);
            String processDefinitionTenantId = Optional.ofNullable(rootNode.get("toProcessDefinitionTenantId")).map(JsonNode::textValue).orElse(null);
            documentBuilder.setTenantId(processDefinitionTenantId);
            JsonNode activityMigrationMappings = rootNode.get("activityMappings");
            if (activityMigrationMappings != null) {
                for (JsonNode mappingNode : activityMigrationMappings) {
                    Class mappingClass = null;
                    if (isSingleTextValue.test(mappingNode.get("fromActivityId")) && isSingleTextValue.test(mappingNode.get("toActivityId"))) {
                        mappingClass = ActivityMigrationMapping.OneToOneMapping.class;
                    }
                    if (isSingleTextValue.test(mappingNode.get("fromActivityId")) && isMultiValue.test(mappingNode.get("toActivityIds"))) {
                        mappingClass = ActivityMigrationMapping.OneToManyMapping.class;
                    }
                    if (isMultiValue.test(mappingNode.get("fromActivityIds")) && isSingleTextValue.test(mappingNode.get("toActivityId"))) {
                        mappingClass = ActivityMigrationMapping.ManyToOneMapping.class;
                    }
                    BaseActivityMigrationMappingConverter mappingConverter = activityMigrationMappingConverters.get(mappingClass);
                    Object mapping = mappingConverter.convertFromJson(mappingNode, objectMapper);
                    documentBuilder.addActivityMigrationMapping((ActivityMigrationMapping)mapping);
                }
            }
            if ((processInstanceVariablesNode = rootNode.get("processInstanceVariables")) != null) {
                Map processInstanceVariables = (Map)ProcessInstanceMigrationDocumentConverter.convertFromJsonNodeToObject(processInstanceVariablesNode, objectMapper);
                documentBuilder.addProcessInstanceVariables(processInstanceVariables);
            }
            return documentBuilder.build();
        }
        catch (IOException e) {
            throw new FlowableException("Error parsing Process Instance Migration Document", (Throwable)e);
        }
    }

    protected static JsonNode convertToJsonProcessInstanceVariables(ProcessInstanceMigrationDocument processInstanceMigrationDocument, ObjectMapper objectMapper) {
        Map<String, Object> processInstanceVariables = processInstanceMigrationDocument.getProcessInstanceVariables();
        if (processInstanceVariables != null && !processInstanceVariables.isEmpty()) {
            return objectMapper.valueToTree(processInstanceVariables);
        }
        return null;
    }

    static {
        activityMigrationMappingConverters.put(ActivityMigrationMapping.OneToOneMapping.class, new OneToOneMappingConverter());
        activityMigrationMappingConverters.put(ActivityMigrationMapping.OneToManyMapping.class, new OneToManyMappingConverter());
        activityMigrationMappingConverters.put(ActivityMigrationMapping.ManyToOneMapping.class, new ManyToOneMappingConverter());
    }

    public static class OneToManyMappingConverter
    extends BaseActivityMigrationMappingConverter<ActivityMigrationMapping.OneToManyMapping> {
        @Override
        protected ObjectNode convertMappingInfoToJson(ActivityMigrationMapping.OneToManyMapping mapping, ObjectMapper objectMapper) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("fromActivityId", mapping.getFromActivityId());
            JsonNode toActivityIdsNode = objectMapper.valueToTree(mapping.getToActivityIds());
            mappingNode.set("toActivityIds", toActivityIdsNode);
            mappingNode.setAll(this.convertAdditionalMappingInfoToJson(mapping, objectMapper));
            return mappingNode;
        }

        @Override
        public JsonNode convertLocalVariablesToJson(ActivityMigrationMapping.OneToManyMapping mapping, ObjectMapper objectMapper) {
            Map<String, Map<String, Object>> activitiesLocalVariables = mapping.getActivitiesLocalVariables();
            if (activitiesLocalVariables != null && !activitiesLocalVariables.isEmpty()) {
                return objectMapper.valueToTree(activitiesLocalVariables);
            }
            return null;
        }

        @Override
        protected JsonNode convertNewAssigneeToJson(ActivityMigrationMapping.OneToManyMapping mapping, ObjectMapper objectMapper) {
            return null;
        }

        @Override
        public ActivityMigrationMapping.OneToManyMapping convertFromJson(JsonNode jsonNode, ObjectMapper objectMapper) {
            String fromActivityId = jsonNode.get("fromActivityId").textValue();
            JsonNode toActivityIdsNode = jsonNode.get("toActivityIds");
            List toActivityIds = (List)objectMapper.convertValue((Object)toActivityIdsNode, (TypeReference)new TypeReference<List<String>>(){});
            ActivityMigrationMapping.OneToManyMapping oneToManyMapping = ActivityMigrationMapping.createMappingFor(fromActivityId, toActivityIds);
            this.convertAdditionalMappingInfoFromJson(oneToManyMapping, jsonNode);
            Map localVariables = (Map)this.getLocalVariablesFromJson(jsonNode, objectMapper);
            if (localVariables != null) {
                oneToManyMapping.withLocalVariables(localVariables);
            }
            return oneToManyMapping;
        }
    }

    public static class ManyToOneMappingConverter
    extends BaseActivityMigrationMappingConverter<ActivityMigrationMapping.ManyToOneMapping> {
        @Override
        protected ObjectNode convertMappingInfoToJson(ActivityMigrationMapping.ManyToOneMapping mapping, ObjectMapper objectMapper) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            JsonNode fromActivityIdsNode = objectMapper.valueToTree(mapping.getFromActivityIds());
            mappingNode.set("fromActivityIds", fromActivityIdsNode);
            mappingNode.put("toActivityId", mapping.getToActivityId());
            mappingNode.setAll(this.convertAdditionalMappingInfoToJson(mapping, objectMapper));
            return mappingNode;
        }

        @Override
        public JsonNode convertLocalVariablesToJson(ActivityMigrationMapping.ManyToOneMapping mapping, ObjectMapper objectMapper) {
            Map<String, Object> activityLocalVariables = mapping.getActivityLocalVariables();
            if (activityLocalVariables != null && !activityLocalVariables.isEmpty()) {
                return objectMapper.valueToTree(activityLocalVariables);
            }
            return null;
        }

        @Override
        protected JsonNode convertNewAssigneeToJson(ActivityMigrationMapping.ManyToOneMapping mapping, ObjectMapper objectMapper) {
            return objectMapper.valueToTree((Object)mapping.getWithNewAssignee());
        }

        @Override
        public ActivityMigrationMapping.ManyToOneMapping convertFromJson(JsonNode jsonNode, ObjectMapper objectMapper) {
            JsonNode fromActivityIdsNode = jsonNode.get("fromActivityIds");
            List fromActivityIds = (List)objectMapper.convertValue((Object)fromActivityIdsNode, (TypeReference)new TypeReference<List<String>>(){});
            String toActivityId = jsonNode.get("toActivityId").textValue();
            ActivityMigrationMapping.ManyToOneMapping manyToOneMapping = ActivityMigrationMapping.createMappingFor(fromActivityIds, toActivityId);
            this.convertAdditionalMappingInfoFromJson(manyToOneMapping, jsonNode);
            Optional.ofNullable(this.getNewAssigneeFromJson(jsonNode)).ifPresent(manyToOneMapping::withNewAssignee);
            Map localVariables = (Map)this.getLocalVariablesFromJson(jsonNode, objectMapper);
            if (localVariables != null) {
                manyToOneMapping.withLocalVariables(localVariables);
            }
            return manyToOneMapping;
        }
    }

    public static class OneToOneMappingConverter
    extends BaseActivityMigrationMappingConverter<ActivityMigrationMapping.OneToOneMapping> {
        @Override
        protected ObjectNode convertMappingInfoToJson(ActivityMigrationMapping.OneToOneMapping mapping, ObjectMapper objectMapper) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("fromActivityId", mapping.getFromActivityId());
            mappingNode.put("toActivityId", mapping.getToActivityId());
            mappingNode.setAll(this.convertAdditionalMappingInfoToJson(mapping, objectMapper));
            return mappingNode;
        }

        @Override
        public JsonNode convertLocalVariablesToJson(ActivityMigrationMapping.OneToOneMapping mapping, ObjectMapper objectMapper) {
            Map<String, Object> activityLocalVariables = mapping.getActivityLocalVariables();
            if (activityLocalVariables != null && !activityLocalVariables.isEmpty()) {
                return objectMapper.valueToTree(activityLocalVariables);
            }
            return null;
        }

        @Override
        protected JsonNode convertNewAssigneeToJson(ActivityMigrationMapping.OneToOneMapping mapping, ObjectMapper objectMapper) {
            return objectMapper.valueToTree((Object)mapping.getWithNewAssignee());
        }

        @Override
        public ActivityMigrationMapping.OneToOneMapping convertFromJson(JsonNode jsonNode, ObjectMapper objectMapper) {
            String fromActivityId = jsonNode.get("fromActivityId").textValue();
            String toActivityId = jsonNode.get("toActivityId").textValue();
            ActivityMigrationMapping.OneToOneMapping oneToOneMapping = ActivityMigrationMapping.createMappingFor(fromActivityId, toActivityId);
            this.convertAdditionalMappingInfoFromJson(oneToOneMapping, jsonNode);
            Optional.ofNullable(this.getNewAssigneeFromJson(jsonNode)).ifPresent(oneToOneMapping::withNewAssignee);
            Map localVariables = (Map)this.getLocalVariablesFromJson(jsonNode, objectMapper);
            if (localVariables != null) {
                oneToOneMapping.withLocalVariables(localVariables);
            }
            return oneToOneMapping;
        }
    }

    public static abstract class BaseActivityMigrationMappingConverter<T extends ActivityMigrationMapping> {
        public ObjectNode convertToJson(T mapping, ObjectMapper objectMapper) {
            JsonNode variablesToJsonNode;
            ObjectNode mappingNode = this.convertMappingInfoToJson(mapping, objectMapper);
            JsonNode newAssigneeToJsonNode = this.convertNewAssigneeToJson(mapping, objectMapper);
            if (newAssigneeToJsonNode != null && !newAssigneeToJsonNode.isNull()) {
                mappingNode.set("newAssignee", newAssigneeToJsonNode);
            }
            if ((variablesToJsonNode = this.convertLocalVariablesToJson(mapping, objectMapper)) != null && !variablesToJsonNode.isNull()) {
                mappingNode.set("localVariables", variablesToJsonNode);
            }
            return mappingNode;
        }

        protected abstract ObjectNode convertMappingInfoToJson(T var1, ObjectMapper var2);

        protected ObjectNode convertAdditionalMappingInfoToJson(T mapping, ObjectMapper objectMapper) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            if (((ActivityMigrationMapping)mapping).isToParentProcess()) {
                mappingNode.put("inParentProcessOfCallActivityId", ((ActivityMigrationMapping)mapping).getFromCallActivityId());
            }
            if (((ActivityMigrationMapping)mapping).isToCallActivity()) {
                mappingNode.put("inSubProcessOfCallActivityId", ((ActivityMigrationMapping)mapping).getToCallActivityId());
                mappingNode.put("callActivityProcessDefinitionVersion", ((ActivityMigrationMapping)mapping).getCallActivityProcessDefinitionVersion());
            }
            return mappingNode;
        }

        protected abstract JsonNode convertLocalVariablesToJson(T var1, ObjectMapper var2);

        protected abstract JsonNode convertNewAssigneeToJson(T var1, ObjectMapper var2);

        public abstract T convertFromJson(JsonNode var1, ObjectMapper var2);

        protected <M extends ActivityMigrationMappingOptions<T>> void convertAdditionalMappingInfoFromJson(M mapping, JsonNode jsonNode) {
            Optional<JsonNode> callActivityOfParentProcess = Optional.ofNullable(jsonNode.get("inParentProcessOfCallActivityId"));
            if (callActivityOfParentProcess.isPresent()) {
                callActivityOfParentProcess.map(JsonNode::textValue).ifPresent(mapping::inParentProcessOfCallActivityId);
                return;
            }
            Optional<JsonNode> ofCallActivityId = Optional.ofNullable(jsonNode.get("inSubProcessOfCallActivityId"));
            Optional<JsonNode> subProcDefVer = Optional.ofNullable(jsonNode.get("callActivityProcessDefinitionVersion"));
            if (ofCallActivityId.isPresent()) {
                if (subProcDefVer.isPresent()) {
                    mapping.inSubProcessOfCallActivityId(ofCallActivityId.get().textValue(), subProcDefVer.get().intValue());
                } else {
                    mapping.inSubProcessOfCallActivityId(ofCallActivityId.get().textValue());
                }
            }
        }

        protected <V> V getLocalVariablesFromJson(JsonNode jsonNode, ObjectMapper objectMapper) {
            JsonNode localVariablesNode = jsonNode.get("localVariables");
            if (localVariablesNode != null) {
                return (V)ProcessInstanceMigrationDocumentConverter.convertFromJsonNodeToObject(localVariablesNode, objectMapper);
            }
            return null;
        }

        protected String getNewAssigneeFromJson(JsonNode jsonNode) {
            if (isSingleTextValue.test(jsonNode.get("newAssignee"))) {
                return jsonNode.get("newAssignee").textValue();
            }
            return null;
        }
    }
}

