/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.eventregistry.json.converter.ChannelValidator;
import org.flowable.eventregistry.json.converter.FlowableEventJsonException;
import org.flowable.eventregistry.json.converter.InboundChannelModelValidator;
import org.flowable.eventregistry.json.converter.OutboundChannelModelValidator;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionInboundChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionOutboundChannelModel;
import org.flowable.eventregistry.model.JmsInboundChannelModel;
import org.flowable.eventregistry.model.JmsOutboundChannelModel;
import org.flowable.eventregistry.model.KafkaInboundChannelModel;
import org.flowable.eventregistry.model.KafkaOutboundChannelModel;
import org.flowable.eventregistry.model.RabbitInboundChannelModel;
import org.flowable.eventregistry.model.RabbitOutboundChannelModel;

public class ChannelJsonConverter {
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected List<ChannelValidator> validators = new ArrayList<ChannelValidator>();

    public ChannelJsonConverter() {
        this.addValidator(new OutboundChannelModelValidator());
        this.addValidator(new InboundChannelModelValidator());
    }

    public ChannelJsonConverter(Collection<ChannelValidator> validators) {
        this.validators = new ArrayList<ChannelValidator>(validators);
    }

    public ChannelModel convertToChannelModel(String modelJson) {
        try {
            JsonNode channelNode = this.objectMapper.readTree(modelJson);
            Class<? extends ChannelModel> channelClass = this.determineChannelModelClass(channelNode);
            ChannelModel channelModel = (ChannelModel)this.objectMapper.convertValue((Object)channelNode, channelClass);
            this.validateChannel(channelModel);
            return channelModel;
        }
        catch (FlowableEventJsonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FlowableEventJsonException("Error reading channel json", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Class<? extends ChannelModel> determineChannelModelClass(JsonNode channelNode) {
        String channelType = channelNode.path("channelType").asText(null);
        String type = channelNode.path("type").asText(null);
        if ("outbound".equals(channelType)) {
            if ("jms".equals(type)) {
                return JmsOutboundChannelModel.class;
            }
            if ("rabbit".equals(type)) {
                return RabbitOutboundChannelModel.class;
            }
            if ("kafka".equals(type)) {
                return KafkaOutboundChannelModel.class;
            }
            if (!"expression".equals(type)) throw new FlowableEventJsonException("Not supported outbound channel model type was found " + type);
            return DelegateExpressionOutboundChannelModel.class;
        }
        if ("jms".equals(type)) {
            return JmsInboundChannelModel.class;
        }
        if ("rabbit".equals(type)) {
            return RabbitInboundChannelModel.class;
        }
        if ("kafka".equals(type)) {
            return KafkaInboundChannelModel.class;
        }
        if (!"expression".equals(type)) throw new FlowableEventJsonException("Not supported inbound channel model type was found " + type);
        return DelegateExpressionInboundChannelModel.class;
    }

    protected void validateChannel(ChannelModel channelModel) {
        for (ChannelValidator validator : this.validators) {
            validator.validateChannel(channelModel);
        }
    }

    public String convertToJson(ChannelModel definition) {
        try {
            return this.objectMapper.writeValueAsString((Object)definition);
        }
        catch (Exception e) {
            throw new FlowableEventJsonException("Error writing channel json", e);
        }
    }

    public List<ChannelValidator> getValidators() {
        return this.validators;
    }

    public void addValidator(ChannelValidator validator) {
        this.validators.add(validator);
    }

    public void setValidators(List<ChannelValidator> validators) {
        this.validators = validators;
    }
}

