/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.entity.ContentType;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestResponseFactory;
import org.flowable.eventregistry.rest.service.api.repository.BaseDeploymentResource;
import org.flowable.eventregistry.rest.service.api.repository.DeploymentResourceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Registry Deployment"}, description="Manage Event Registry Deployment", authorizations={@Authorization(value="basicAuth")})
public class DeploymentResourceResource
extends BaseDeploymentResource {
    @Autowired
    protected EventRegistryRestResponseFactory restResponseFactory;
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected EventRepositoryService repositoryService;

    @ApiOperation(value="Get a deployment resource", tags={"Deployment"}, notes="Replace ** by ResourceId")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both deployment and resource have been found and the resource has been returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found or there is no resource with the given id present in the deployment. The status-description contains additional information.")})
    @GetMapping(value={"/event-registry-repository/deployments/{deploymentId}/resources/**"}, produces={"application/json"})
    public DeploymentResourceResponse getDeploymentResource(@ApiParam(name="deploymentId") @PathVariable(value="deploymentId") String deploymentId, HttpServletRequest request) {
        EventDeployment deployment = this.getEventDeployment(deploymentId);
        String pathInfo = request.getPathInfo();
        String resourceName = pathInfo.replace("/event-registry-repository/deployments/" + deployment.getId() + "/resources/", "");
        List resourceList = this.repositoryService.getDeploymentResourceNames(deployment.getId());
        if (resourceList.contains(resourceName)) {
            String contentType = null;
            contentType = resourceName.toLowerCase().endsWith(".event") || resourceName.toLowerCase().endsWith(".channel") ? ContentType.APPLICATION_JSON.getMimeType() : this.contentTypeResolver.resolveContentType(resourceName);
            DeploymentResourceResponse response = this.restResponseFactory.createDeploymentResourceResponse(deploymentId, resourceName, contentType);
            return response;
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with id '" + resourceName + "' in deployment '" + deploymentId + "'.");
    }
}

