/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.util.Collection;
import java.util.Map;
import org.flowable.eventregistry.api.CorrelationKeyGenerator;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRegistryEvent;
import org.flowable.eventregistry.api.EventRegistryEventConsumer;
import org.flowable.eventregistry.api.InboundEventProcessor;
import org.flowable.eventregistry.api.OutboundEventProcessor;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.impl.DefaultCorrelationKeyGenerator;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.model.InboundChannelModel;

public class DefaultEventRegistry
implements EventRegistry {
    protected EventRegistryEngineConfiguration engineConfiguration;
    protected CorrelationKeyGenerator<Map<String, Object>> correlationKeyGenerator;
    protected InboundEventProcessor inboundEventProcessor;
    protected OutboundEventProcessor outboundEventProcessor;

    public DefaultEventRegistry(EventRegistryEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
        this.correlationKeyGenerator = new DefaultCorrelationKeyGenerator();
    }

    public void setInboundEventProcessor(InboundEventProcessor inboundEventProcessor) {
        this.inboundEventProcessor = inboundEventProcessor;
    }

    public void setOutboundEventProcessor(OutboundEventProcessor outboundEventProcessor) {
        this.outboundEventProcessor = outboundEventProcessor;
    }

    public void eventReceived(InboundChannelModel channelModel, String event) {
        this.inboundEventProcessor.eventReceived(channelModel, event);
    }

    public void sendEventToConsumers(EventRegistryEvent eventRegistryEvent) {
        Collection engineEventRegistryEventConsumers = this.engineConfiguration.getEventRegistryEventConsumers().values();
        for (EventRegistryEventConsumer eventConsumer : engineEventRegistryEventConsumers) {
            eventConsumer.eventReceived(eventRegistryEvent);
        }
    }

    public void sendEventOutbound(EventInstance eventInstance) {
        this.outboundEventProcessor.sendEvent(eventInstance);
    }

    public void registerEventRegistryEventConsumer(EventRegistryEventConsumer eventRegistryEventBusConsumer) {
        this.engineConfiguration.getEventRegistryEventConsumers().put(eventRegistryEventBusConsumer.getConsumerKey(), eventRegistryEventBusConsumer);
    }

    public void removeFlowableEventRegistryEventConsumer(EventRegistryEventConsumer eventRegistryEventBusConsumer) {
        this.engineConfiguration.getEventRegistryEventConsumers().remove(eventRegistryEventBusConsumer.getConsumerKey());
    }

    public String generateKey(Map<String, Object> data) {
        return this.correlationKeyGenerator.generateKey(data);
    }
}

