/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.model.EventModelBuilder;
import org.flowable.eventregistry.impl.EventRepositoryServiceImpl;
import org.flowable.eventregistry.json.converter.EventJsonConverter;
import org.flowable.eventregistry.model.EventCorrelationParameter;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;

public class EventModelBuilderImpl
implements EventModelBuilder {
    protected EventRepositoryServiceImpl eventRepository;
    protected String deploymentName;
    protected String resourceName;
    protected String category;
    protected String parentDeploymentId;
    protected String deploymentTenantId;
    protected String key;
    protected Collection<String> inboundChannelKeys;
    protected Collection<String> outboundChannelKeys;
    protected Map<String, EventCorrelationParameter> correlationParameterDefinitions = new LinkedHashMap<String, EventCorrelationParameter>();
    protected Map<String, EventPayload> eventPayloadDefinitions = new LinkedHashMap<String, EventPayload>();

    public EventModelBuilderImpl(EventRepositoryServiceImpl eventRepository) {
        this.eventRepository = eventRepository;
    }

    public EventModelBuilder key(String key) {
        this.key = key;
        return this;
    }

    public EventModelBuilder deploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public EventModelBuilder resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public EventModelBuilder category(String category) {
        this.category = category;
        return this;
    }

    public EventModelBuilder parentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public EventModelBuilder deploymentTenantId(String deploymentTenantId) {
        this.deploymentTenantId = deploymentTenantId;
        return this;
    }

    public EventModelBuilder inboundChannelKey(String channelKey) {
        if (this.inboundChannelKeys == null) {
            this.inboundChannelKeys = new HashSet<String>();
        }
        this.inboundChannelKeys.add(channelKey);
        return this;
    }

    public EventModelBuilder inboundChannelKeys(Collection<String> channelKeys) {
        channelKeys.forEach(this::inboundChannelKey);
        return this;
    }

    public EventModelBuilder outboundChannelKey(String channelKey) {
        if (this.outboundChannelKeys == null) {
            this.outboundChannelKeys = new HashSet<String>();
        }
        this.outboundChannelKeys.add(channelKey);
        return this;
    }

    public EventModelBuilder outboundChannelKeys(Collection<String> channelKeys) {
        channelKeys.forEach(this::outboundChannelKey);
        return this;
    }

    public EventModelBuilder correlationParameter(String name, String type) {
        this.correlationParameterDefinitions.put(name, new EventCorrelationParameter(name, type));
        this.payload(name, type);
        return this;
    }

    public EventModelBuilder payload(String name, String type) {
        this.eventPayloadDefinitions.put(name, new EventPayload(name, type));
        return this;
    }

    public EventModel createEventModel() {
        return this.buildEventModel();
    }

    public EventDeployment deploy() {
        if (this.resourceName == null) {
            throw new FlowableIllegalArgumentException("A resource name is mandatory");
        }
        EventModel eventModel = this.buildEventModel();
        EventDeployment eventDeployment = this.eventRepository.createDeployment().name(this.deploymentName).addEventDefinition(this.resourceName, new EventJsonConverter().convertToJson(eventModel)).category(this.category).parentDeploymentId(this.parentDeploymentId).tenantId(this.deploymentTenantId).deploy();
        return eventDeployment;
    }

    protected EventModel buildEventModel() {
        EventModel eventModel = new EventModel();
        if (!StringUtils.isNotEmpty((CharSequence)this.key)) {
            throw new FlowableIllegalArgumentException("An event definition key is mandatory");
        }
        eventModel.setKey(this.key);
        if (this.inboundChannelKeys != null) {
            eventModel.setInboundChannelKeys(this.inboundChannelKeys);
        }
        if (this.outboundChannelKeys != null) {
            eventModel.setOutboundChannelKeys(this.outboundChannelKeys);
        }
        eventModel.getCorrelationParameters().addAll(this.correlationParameterDefinitions.values());
        eventModel.getPayload().addAll(this.eventPayloadDefinitions.values());
        return eventModel;
    }
}

