/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.pipeline;

import java.util.Collection;
import org.flowable.eventregistry.api.EventRegistryEvent;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.InboundEventDeserializer;
import org.flowable.eventregistry.api.InboundEventKeyDetector;
import org.flowable.eventregistry.api.InboundEventPayloadExtractor;
import org.flowable.eventregistry.api.InboundEventProcessingPipeline;
import org.flowable.eventregistry.api.InboundEventTenantDetector;
import org.flowable.eventregistry.api.InboundEventTransformer;
import org.flowable.eventregistry.api.runtime.EventCorrelationParameterInstance;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventInstanceImpl;
import org.flowable.eventregistry.model.EventModel;

public class DefaultInboundEventProcessingPipeline<T>
implements InboundEventProcessingPipeline {
    protected EventRepositoryService eventRepositoryService;
    protected InboundEventDeserializer<T> inboundEventDeserializer;
    protected InboundEventKeyDetector<T> inboundEventKeyDetector;
    protected InboundEventTenantDetector<T> inboundEventTenantDetector;
    protected InboundEventPayloadExtractor<T> inboundEventPayloadExtractor;
    protected InboundEventTransformer inboundEventTransformer;

    public DefaultInboundEventProcessingPipeline(EventRepositoryService eventRepositoryService, InboundEventDeserializer<T> inboundEventDeserializer, InboundEventKeyDetector<T> inboundEventKeyDetector, InboundEventTenantDetector<T> inboundEventTenantDetector, InboundEventPayloadExtractor<T> inboundEventPayloadExtractor, InboundEventTransformer inboundEventTransformer) {
        this.eventRepositoryService = eventRepositoryService;
        this.inboundEventDeserializer = inboundEventDeserializer;
        this.inboundEventKeyDetector = inboundEventKeyDetector;
        this.inboundEventTenantDetector = inboundEventTenantDetector;
        this.inboundEventPayloadExtractor = inboundEventPayloadExtractor;
        this.inboundEventTransformer = inboundEventTransformer;
    }

    public Collection<EventRegistryEvent> run(String channelKey, String rawEvent) {
        T event = this.deserialize(rawEvent);
        String eventKey = this.detectEventDefinitionKey(event);
        String tenantId = "";
        EventModel eventModel = null;
        if (this.inboundEventTenantDetector != null) {
            tenantId = this.inboundEventTenantDetector.detectTenantId(event);
            eventModel = this.eventRepositoryService.getEventModelByKey(eventKey, tenantId);
        } else {
            eventModel = this.eventRepositoryService.getEventModelByKey(eventKey);
        }
        EventInstanceImpl eventInstance = new EventInstanceImpl(eventModel, this.extractCorrelationParameters(eventModel, event), this.extractPayload(eventModel, event), tenantId);
        return this.transform(eventInstance);
    }

    public T deserialize(String rawEvent) {
        return (T)this.inboundEventDeserializer.deserialize(rawEvent);
    }

    public String detectEventDefinitionKey(T event) {
        return this.inboundEventKeyDetector.detectEventDefinitionKey(event);
    }

    public Collection<EventCorrelationParameterInstance> extractCorrelationParameters(EventModel eventDefinition, T event) {
        return this.inboundEventPayloadExtractor.extractCorrelationParameters(eventDefinition, event);
    }

    public Collection<EventPayloadInstance> extractPayload(EventModel eventDefinition, T event) {
        return this.inboundEventPayloadExtractor.extractPayload(eventDefinition, event);
    }

    public Collection<EventRegistryEvent> transform(EventInstance eventInstance) {
        return this.inboundEventTransformer.transform(eventInstance);
    }

    public InboundEventDeserializer<T> getInboundEventDeserializer() {
        return this.inboundEventDeserializer;
    }

    public void setInboundEventDeserializer(InboundEventDeserializer<T> inboundEventDeserializer) {
        this.inboundEventDeserializer = inboundEventDeserializer;
    }

    public InboundEventKeyDetector<T> getInboundEventKeyDetector() {
        return this.inboundEventKeyDetector;
    }

    public void setInboundEventKeyDetector(InboundEventKeyDetector<T> inboundEventKeyDetector) {
        this.inboundEventKeyDetector = inboundEventKeyDetector;
    }

    public InboundEventTenantDetector<T> getInboundEventTenantDetector() {
        return this.inboundEventTenantDetector;
    }

    public void setInboundEventTenantDetector(InboundEventTenantDetector<T> inboundEventTenantDetector) {
        this.inboundEventTenantDetector = inboundEventTenantDetector;
    }

    public InboundEventPayloadExtractor<T> getInboundEventPayloadExtractor() {
        return this.inboundEventPayloadExtractor;
    }

    public void setInboundEventPayloadExtractor(InboundEventPayloadExtractor<T> inboundEventPayloadExtractor) {
        this.inboundEventPayloadExtractor = inboundEventPayloadExtractor;
    }

    public InboundEventTransformer getInboundEventTransformer() {
        return this.inboundEventTransformer;
    }

    public void setInboundEventTransformer(InboundEventTransformer inboundEventTransformer) {
        this.inboundEventTransformer = inboundEventTransformer;
    }
}

