/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.flowable.eventregistry.impl.persistence.entity;

import java.util.List;
import java.util.Map;

import org.flowable.common.engine.impl.persistence.entity.EntityManager;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.impl.EventDefinitionQueryImpl;

/**
 * @author Joram Barrez
 */
public interface EventDefinitionEntityManager extends EntityManager<EventDefinitionEntity> {
    
    EventDefinitionEntity findLatestEventDefinitionByKey(String eventDefinitionKey);

    EventDefinitionEntity findLatestEventDefinitionByKeyAndTenantId(String eventDefinitionKey, String tenantId);

    List<EventDefinition> findEventDefinitionsByQueryCriteria(EventDefinitionQueryImpl eventQuery);

    long findEventDefinitionCountByQueryCriteria(EventDefinitionQueryImpl eventQuery);

    EventDefinitionEntity findEventDefinitionByDeploymentAndKey(String deploymentId, String eventDefinitionKey);

    EventDefinitionEntity findEventDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String eventDefinitionKey, String tenantId);
    
    EventDefinitionEntity findEventDefinitionByKeyAndVersionAndTenantId(String eventDefinitionKey, Integer eventVersion, String tenantId);

    List<EventDefinition> findEventDefinitionsByNativeQuery(Map<String, Object> parameterMap);

    long findEventDefinitionCountByNativeQuery(Map<String, Object> parameterMap);

    void updateEventDefinitionTenantIdForDeployment(String deploymentId, String newTenantId);

    void deleteEventDefinitionsByDeploymentId(String deploymentId);

}