/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormInstance;
import org.flowable.form.engine.impl.FormInstanceQueryImpl;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntityManager;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class DeleteFormInstancesByProcessDefinitionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public DeleteFormInstancesByProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("processDefinitionId is null");
        }
        FormInstanceEntityManager formInstanceEntityManager = CommandContextUtil.getFormInstanceEntityManager(commandContext);
        FormResourceEntityManager resourceEntityManager = CommandContextUtil.getResourceEntityManager(commandContext);
        FormInstanceQueryImpl formInstanceQuery = new FormInstanceQueryImpl(commandContext);
        formInstanceQuery.processDefinitionId(this.processDefinitionId);
        List<FormInstance> formInstances = formInstanceEntityManager.findFormInstancesByQueryCriteria(formInstanceQuery);
        for (FormInstance formInstance : formInstances) {
            if (formInstance.getFormValuesId() == null) continue;
            resourceEntityManager.delete(formInstance.getFormValuesId());
        }
        formInstanceEntityManager.deleteFormInstancesByProcessDefinitionId(this.processDefinitionId);
        return null;
    }
}

