/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class SetFormDefinitionCategoryCmd
implements Command<Void> {
    protected String formDefinitionId;
    protected String category;

    public SetFormDefinitionCategoryCmd(String formDefinitionId, String category) {
        this.formDefinitionId = formDefinitionId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.formDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Form definition id is null");
        }
        FormDefinitionEntity formDefinition = (FormDefinitionEntity)CommandContextUtil.getFormDefinitionEntityManager(commandContext).findById(this.formDefinitionId);
        if (formDefinition == null) {
            throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'");
        }
        formDefinition.setCategory(this.category);
        DeploymentCache<FormDefinitionCacheEntry> formDefinitionCache = CommandContextUtil.getFormEngineConfiguration().getFormDefinitionCache();
        if (formDefinitionCache != null) {
            formDefinitionCache.remove(this.formDefinitionId);
        }
        CommandContextUtil.getFormDefinitionEntityManager(commandContext).update(formDefinition);
        return null;
    }

    public String getFormDefinitionId() {
        return this.formDefinitionId;
    }

    public void setFormDefinitionId(String formDefinitionId) {
        this.formDefinitionId = formDefinitionId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

