/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest.service.api.form;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.form.api.FormInstanceQuery;
import org.flowable.form.api.FormService;
import org.flowable.form.engine.impl.FormInstanceQueryProperty;
import org.flowable.form.rest.FormRestApiInterceptor;
import org.flowable.form.rest.FormRestResponseFactory;
import org.flowable.form.rest.service.api.form.FormInstanceQueryRequest;
import org.flowable.form.rest.service.api.form.FormInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseFormInstanceResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected FormService formService;
    @Autowired
    protected FormRestResponseFactory restResponseFactory;
    @Autowired(required=false)
    protected FormRestApiInterceptor restApiInterceptor;

    protected DataResponse<FormInstanceResponse> getQueryResponse(FormInstanceQueryRequest queryRequest, Map<String, String> requestParams) {
        FormInstanceQuery query = this.formService.createFormInstanceQuery();
        if (queryRequest.getId() != null) {
            query.id(queryRequest.getId());
        }
        if (queryRequest.getFormDefinitionId() != null) {
            query.formDefinitionId(queryRequest.getFormDefinitionId());
        }
        if (queryRequest.getFormDefinitionIdLike() != null) {
            query.formDefinitionIdLike(queryRequest.getFormDefinitionIdLike());
        }
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getTaskIdLike() != null) {
            query.taskIdLike(queryRequest.getTaskIdLike());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessInstanceIdLike() != null) {
            query.processInstanceIdLike(queryRequest.getProcessInstanceIdLike());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getProcessDefinitionIdLike() != null) {
            query.processDefinitionIdLike(queryRequest.getProcessDefinitionIdLike());
        }
        if (queryRequest.getScopeId() != null) {
            query.scopeId(queryRequest.getScopeId());
        }
        if (queryRequest.getScopeType() != null) {
            query.scopeType(queryRequest.getScopeType());
        }
        if (queryRequest.getScopeDefinitionId() != null) {
            query.scopeDefinitionId(queryRequest.getScopeDefinitionId());
        }
        if (queryRequest.getSubmittedBy() != null) {
            query.submittedBy(queryRequest.getSubmittedBy());
        }
        if (queryRequest.getSubmittedByLike() != null) {
            query.submittedByLike(queryRequest.getSubmittedByLike());
        }
        if (queryRequest.getTenantId() != null) {
            query.tenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.tenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.isWithoutTenantId())) {
            query.withoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessFormInstanceInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(requestParams, (PaginateRequest)queryRequest, (Query)query, (String)"submittedDate", allowedSortProperties, this.restResponseFactory::createFormInstanceResponse);
    }

    static {
        allowedSortProperties.put("submittedDate", (QueryProperty)FormInstanceQueryProperty.SUBMITTED_DATE);
        allowedSortProperties.put("tenantId", (QueryProperty)FormInstanceQueryProperty.TENANT_ID);
    }
}

