/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdmEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdmEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, IdmEngine> idmEngines;
    protected static Map<String, EngineInfo> idmEngineInfosByName;
    protected static Map<String, EngineInfo> idmEngineInfosByResourceUrl;
    protected static List<EngineInfo> idmEngineInfos;

    public static synchronized void init() {
        if (!IdmEngines.isInitialized()) {
            if (idmEngines == null) {
                idmEngines = new HashMap<String, IdmEngine>();
            }
            ClassLoader classLoader = IdmEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.idm.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable.idm.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                LOGGER.info("Initializing idm engine using configuration '{}'", (Object)resource.toString());
                IdmEngines.initIdmEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-idm-context.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable-idm-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                LOGGER.info("Initializing idm engine using Spring configuration '{}'", (Object)resource.toString());
                IdmEngines.initIdmEngineFromSpringResource(resource);
            }
            IdmEngines.setInitialized(true);
        } else {
            LOGGER.info("Idm engines already initialized");
        }
    }

    protected static void initIdmEngineFromSpringResource(URL resource) {
        try {
            Class springConfigurationHelperClass = ReflectUtil.loadClass((String)"org.flowable.idm.spring.SpringIdmConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildIdmEngine", URL.class);
            IdmEngine idmEngine = (IdmEngine)method.invoke(null, resource);
            String idmEngineName = idmEngine.getName();
            EngineInfo idmEngineInfo = new EngineInfo(idmEngineName, resource.toString(), null);
            idmEngineInfosByName.put(idmEngineName, idmEngineInfo);
            idmEngineInfosByResourceUrl.put(resource.toString(), idmEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize idm engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerIdmEngine(IdmEngine idmEngine) {
        idmEngines.put(idmEngine.getName(), idmEngine);
    }

    public static void unregister(IdmEngine idmEngine) {
        idmEngines.remove(idmEngine.getName());
    }

    private static EngineInfo initIdmEngineFromResource(URL resourceUrl) {
        EngineInfo idmEngineInfo = idmEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (idmEngineInfo != null) {
            idmEngineInfos.remove(idmEngineInfo);
            if (idmEngineInfo.getException() == null) {
                String idmEngineName = idmEngineInfo.getName();
                idmEngines.remove(idmEngineName);
                idmEngineInfosByName.remove(idmEngineName);
            }
            idmEngineInfosByResourceUrl.remove(idmEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOGGER.info("initializing idm engine for resource {}", (Object)resourceUrl);
            IdmEngine idmEngine = IdmEngines.buildIdmEngine(resourceUrl);
            String idmEngineName = idmEngine.getName();
            LOGGER.info("initialised idm engine {}", (Object)idmEngineName);
            idmEngineInfo = new EngineInfo(idmEngineName, resourceUrlString, null);
            idmEngines.put(idmEngineName, idmEngine);
            idmEngineInfosByName.put(idmEngineName, idmEngineInfo);
        }
        catch (Throwable e) {
            LOGGER.error("Exception while initializing idm engine: {}", (Object)e.getMessage(), (Object)e);
            idmEngineInfo = new EngineInfo(null, resourceUrlString, ExceptionUtils.getStackTrace((Throwable)e));
        }
        idmEngineInfosByResourceUrl.put(resourceUrlString, idmEngineInfo);
        idmEngineInfos.add(idmEngineInfo);
        return idmEngineInfo;
    }

    protected static IdmEngine buildIdmEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            IdmEngineConfiguration idmEngineConfiguration = IdmEngineConfiguration.createIdmEngineConfigurationFromInputStream(inputStream);
            IdmEngine idmEngine = idmEngineConfiguration.buildIdmEngine();
            return idmEngine;
        }
        catch (IOException e) {
            throw new FlowableException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IoUtil.closeSilently((InputStream)inputStream);
        }
    }

    public static List<EngineInfo> getIdmEngineInfos() {
        return idmEngineInfos;
    }

    public static EngineInfo getIdmEngineInfo(String idmEngineName) {
        return idmEngineInfosByName.get(idmEngineName);
    }

    public static IdmEngine getDefaultIdmEngine() {
        return IdmEngines.getIdmEngine(NAME_DEFAULT);
    }

    public static IdmEngine getIdmEngine(String idmEngineName) {
        if (!IdmEngines.isInitialized()) {
            IdmEngines.init();
        }
        return idmEngines.get(idmEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        LOGGER.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return IdmEngines.initIdmEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, IdmEngine> getIdmEngines() {
        return idmEngines;
    }

    public static synchronized void destroy() {
        if (IdmEngines.isInitialized()) {
            HashMap<String, IdmEngine> engines = new HashMap<String, IdmEngine>(idmEngines);
            idmEngines = new HashMap<String, IdmEngine>();
            for (String idmEngineName : engines.keySet()) {
                IdmEngine idmEngine = (IdmEngine)engines.get(idmEngineName);
                try {
                    idmEngine.close();
                }
                catch (Exception e) {
                    LOGGER.error("exception while closing {}", (Object)(idmEngineName == null ? "the default idm engine" : "idm engine " + idmEngineName), (Object)e);
                }
            }
            idmEngineInfosByName.clear();
            idmEngineInfosByResourceUrl.clear();
            idmEngineInfos.clear();
            IdmEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        IdmEngines.isInitialized = isInitialized;
    }

    static {
        idmEngines = new HashMap<String, IdmEngine>();
        idmEngineInfosByName = new HashMap<String, EngineInfo>();
        idmEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        idmEngineInfos = new ArrayList<EngineInfo>();
    }
}

