/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTimerToExecutableJobCmd
implements Command<JobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveTimerToExecutableJobCmd.class);
    protected String jobId;

    public MoveTimerToExecutableJobCmd(String jobId) {
        this.jobId = jobId;
    }

    public JobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        TimerJobEntity timerJob = (TimerJobEntity)CommandContextUtil.getTimerJobEntityManager(commandContext).findById(this.jobId);
        if (timerJob == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing timer job {}", (Object)timerJob.getId());
        }
        return CommandContextUtil.getJobManager(commandContext).moveTimerJobToExecutableJob(timerJob);
    }

    public String getJobId() {
        return this.jobId;
    }
}

