/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.concurrent.RejectedExecutionException;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.flowable.common.engine.impl.async.DefaultAsyncTaskExecutor;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.impl.asyncexecutor.AbstractAsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncJobExecutor
extends AbstractAsyncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncJobExecutor.class);
    protected boolean isAsyncJobAcquisitionEnabled = true;
    protected boolean isTimerJobAcquisitionEnabled = true;
    protected boolean isResetExpiredJobEnabled = true;
    protected Thread asyncJobAcquisitionThread;
    protected Thread timerJobAcquisitionThread;
    protected Thread resetExpiredJobThread;
    protected boolean unlockOwnedJobs = true;
    protected AsyncTaskExecutor taskExecutor;
    protected boolean shutdownTaskExecutor;

    @Override
    protected boolean executeAsyncJob(JobInfo job, Runnable runnable) {
        try {
            this.taskExecutor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            this.unacquireJobAfterRejection(job);
            return false;
        }
    }

    protected void unacquireJobAfterRejection(final JobInfo job) {
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        this.jobServiceConfiguration.getCommandExecutor().execute(commandConfig, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                DefaultAsyncJobExecutor.this.jobServiceConfiguration.getJobManager().unacquire(job);
                return null;
            }
        });
    }

    @Override
    protected void startAdditionalComponents() {
        if (!this.isMessageQueueMode) {
            this.initAsyncJobExecutionThreadPool();
            this.startJobAcquisitionThread();
        }
        if (this.unlockOwnedJobs) {
            this.unlockOwnedJobs();
        }
        if (this.timerRunnableNeeded) {
            this.startTimerAcquisitionThread();
        }
        this.startResetExpiredJobsThread();
    }

    @Override
    protected void shutdownAdditionalComponents() {
        this.stopResetExpiredJobsThread();
        this.stopTimerAcquisitionThread();
        this.stopJobAcquisitionThread();
        this.stopExecutingAsyncJobs();
        if (this.unlockOwnedJobs) {
            this.unlockOwnedJobs();
        }
    }

    @Override
    protected ResetExpiredJobsRunnable createResetExpiredJobsRunnable(String resetRunnableName) {
        return new ResetExpiredJobsRunnable(resetRunnableName, this, this.jobServiceConfiguration.getJobEntityManager(), this.jobServiceConfiguration.getTimerJobEntityManager(), this.jobServiceConfiguration.getExternalWorkerJobEntityManager());
    }

    protected void initAsyncJobExecutionThreadPool() {
        if (this.taskExecutor == null) {
            DefaultAsyncTaskExecutor defaultAsyncTaskExecutor = new DefaultAsyncTaskExecutor();
            defaultAsyncTaskExecutor.start();
            this.taskExecutor = defaultAsyncTaskExecutor;
            this.shutdownTaskExecutor = true;
        }
    }

    protected void stopExecutingAsyncJobs() {
        if (this.taskExecutor != null && this.shutdownTaskExecutor) {
            this.taskExecutor.shutdown();
            this.taskExecutor = null;
        }
    }

    protected void startJobAcquisitionThread() {
        if (this.isAsyncJobAcquisitionEnabled) {
            if (this.asyncJobAcquisitionThread == null) {
                this.asyncJobAcquisitionThread = new Thread(this.asyncJobsDueRunnable);
            }
            this.asyncJobAcquisitionThread.start();
        }
    }

    protected void startTimerAcquisitionThread() {
        if (this.isTimerJobAcquisitionEnabled) {
            if (this.timerJobAcquisitionThread == null) {
                this.timerJobAcquisitionThread = new Thread(this.timerJobRunnable);
            }
            this.timerJobAcquisitionThread.start();
        }
    }

    protected void stopJobAcquisitionThread() {
        if (this.asyncJobAcquisitionThread != null) {
            try {
                this.asyncJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the async job acquisition thread to terminate", (Throwable)e);
            }
            this.asyncJobAcquisitionThread = null;
        }
    }

    protected void stopTimerAcquisitionThread() {
        if (this.timerJobAcquisitionThread != null) {
            try {
                this.timerJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
            }
            this.timerJobAcquisitionThread = null;
        }
    }

    protected void startResetExpiredJobsThread() {
        if (this.isResetExpiredJobEnabled) {
            if (this.resetExpiredJobThread == null) {
                this.resetExpiredJobThread = new Thread(this.resetExpiredJobsRunnable);
            }
            this.resetExpiredJobThread.start();
        }
    }

    protected void stopResetExpiredJobsThread() {
        if (this.resetExpiredJobThread != null) {
            try {
                this.resetExpiredJobThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the reset expired jobs thread to terminate", (Throwable)e);
            }
            this.resetExpiredJobThread = null;
        }
    }

    public boolean isAsyncJobAcquisitionEnabled() {
        return this.isAsyncJobAcquisitionEnabled;
    }

    public void setAsyncJobAcquisitionEnabled(boolean isAsyncJobAcquisitionEnabled) {
        this.isAsyncJobAcquisitionEnabled = isAsyncJobAcquisitionEnabled;
    }

    public boolean isTimerJobAcquisitionEnabled() {
        return this.isTimerJobAcquisitionEnabled;
    }

    public void setTimerJobAcquisitionEnabled(boolean isTimerJobAcquisitionEnabled) {
        this.isTimerJobAcquisitionEnabled = isTimerJobAcquisitionEnabled;
    }

    public boolean isResetExpiredJobEnabled() {
        return this.isResetExpiredJobEnabled;
    }

    public void setResetExpiredJobEnabled(boolean isResetExpiredJobEnabled) {
        this.isResetExpiredJobEnabled = isResetExpiredJobEnabled;
    }

    public Thread getTimerJobAcquisitionThread() {
        return this.timerJobAcquisitionThread;
    }

    public void setTimerJobAcquisitionThread(Thread timerJobAcquisitionThread) {
        this.timerJobAcquisitionThread = timerJobAcquisitionThread;
    }

    public Thread getAsyncJobAcquisitionThread() {
        return this.asyncJobAcquisitionThread;
    }

    public void setAsyncJobAcquisitionThread(Thread asyncJobAcquisitionThread) {
        this.asyncJobAcquisitionThread = asyncJobAcquisitionThread;
    }

    public Thread getResetExpiredJobThread() {
        return this.resetExpiredJobThread;
    }

    public void setResetExpiredJobThread(Thread resetExpiredJobThread) {
        this.resetExpiredJobThread = resetExpiredJobThread;
    }

    @Override
    public int getRemainingCapacity() {
        return 99;
    }

    public boolean isUnlockOwnedJobs() {
        return this.unlockOwnedJobs;
    }

    public void setUnlockOwnedJobs(boolean unlockOwnedJobs) {
        this.unlockOwnedJobs = unlockOwnedJobs;
    }

    @Override
    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }
}

