/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.HistoryJobHandler;
import org.flowable.job.service.impl.history.async.AsyncHistoryJobNotApplicableException;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncHistoryJobHandler
implements HistoryJobHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean isAsyncHistoryJsonGroupingEnabled;
    protected String jobType;

    public AbstractAsyncHistoryJobHandler(String jobType) {
        this.jobType = jobType;
    }

    @Override
    public String getType() {
        return this.jobType;
    }

    @Override
    public void execute(HistoryJobEntity job, String configuration, CommandContext commandContext) {
        ObjectMapper objectMapper = commandContext.getObjectMapper();
        if (job.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            try {
                byte[] bytes = this.getJobBytes(job);
                JsonNode historyNode = objectMapper.readTree(bytes);
                if (this.isAsyncHistoryJsonGroupingEnabled() && historyNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)historyNode;
                    for (JsonNode jsonNode : arrayNode) {
                        this.processHistoryJson(commandContext, job, jsonNode);
                    }
                } else {
                    this.processHistoryJson(commandContext, job, historyNode);
                }
            }
            catch (AsyncHistoryJobNotApplicableException e) {
                throw e;
            }
            catch (Exception e) {
                if (!(e instanceof FlowableException) || e instanceof FlowableException && ((FlowableException)e).isLogged()) {
                    this.logger.warn("Could not execute history job", (Throwable)e);
                }
                throw new FlowableException("Could not deserialize async history json for job (id=" + job.getId() + ")", (Throwable)e);
            }
        }
    }

    protected byte[] getJobBytes(HistoryJobEntity job) {
        return job.getAdvancedJobHandlerConfigurationByteArrayRef().getBytes(job.getScopeType());
    }

    protected abstract void processHistoryJson(CommandContext var1, HistoryJobEntity var2, JsonNode var3);

    public boolean isAsyncHistoryJsonGroupingEnabled() {
        return this.isAsyncHistoryJsonGroupingEnabled;
    }

    public void setAsyncHistoryJsonGroupingEnabled(boolean isAsyncHistoryJsonGroupingEnabled) {
        this.isAsyncHistoryJsonGroupingEnabled = isAsyncHistoryJsonGroupingEnabled;
    }
}

