/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.job.service.impl.history.async.AsyncHistoryListener;
import org.flowable.job.service.impl.history.async.AsyncHistorySessionCommandContextCloseListener;

public class AsyncHistorySession
implements Session {
    public static final String TIMESTAMP = "__timeStamp";
    protected CommandContext commandContext;
    protected AsyncHistoryListener asyncHistoryListener;
    protected CommandContextCloseListener commandContextCloseListener;
    protected List<String> jobDataTypes;
    protected TransactionContext transactionContext;
    protected String tenantId;
    protected Map<JobServiceConfiguration, AsyncHistorySessionData> sessionData;

    public AsyncHistorySession(CommandContext commandContext, AsyncHistoryListener asyncHistoryJobListener) {
        this.commandContext = commandContext;
        this.asyncHistoryListener = asyncHistoryJobListener;
        this.initCommandContextCloseListener();
        this.transactionContext = Context.getTransactionContext();
    }

    public AsyncHistorySession(CommandContext commandContext, AsyncHistoryListener asyncHistoryJobListener, List<String> jobDataTypes) {
        this(commandContext, asyncHistoryJobListener);
        this.jobDataTypes = jobDataTypes;
    }

    protected void initCommandContextCloseListener() {
        this.commandContextCloseListener = new AsyncHistorySessionCommandContextCloseListener(this, this.asyncHistoryListener);
    }

    public void addHistoricData(JobServiceConfiguration jobServiceConfiguration, String type, ObjectNode data) {
        this.addHistoricData(jobServiceConfiguration, type, data, null);
    }

    public void addHistoricData(JobServiceConfiguration jobServiceConfiguration, String type, ObjectNode data, String tenantId) {
        AsyncHistorySessionData asyncHistorySessionData;
        data.put(TIMESTAMP, AsyncHistoryDateUtil.formatDate(jobServiceConfiguration.getClock().getCurrentTime()));
        if (this.sessionData == null) {
            this.sessionData = new HashMap<JobServiceConfiguration, AsyncHistorySessionData>();
            this.commandContext.addCloseListener(this.commandContextCloseListener);
        }
        if ((asyncHistorySessionData = this.sessionData.get((Object)jobServiceConfiguration)) == null) {
            asyncHistorySessionData = new AsyncHistorySessionData();
            this.sessionData.put(jobServiceConfiguration, asyncHistorySessionData);
        }
        if (tenantId != null) {
            this.tenantId = tenantId;
        }
        asyncHistorySessionData.addJobData(type, data);
    }

    public void flush() {
    }

    public void close() {
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Map<JobServiceConfiguration, AsyncHistorySessionData> getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Map<JobServiceConfiguration, AsyncHistorySessionData> sessionData) {
        this.sessionData = sessionData;
    }

    public List<String> getJobDataTypes() {
        return this.jobDataTypes;
    }

    public void setJobDataTypes(List<String> jobDataTypes) {
        this.jobDataTypes = jobDataTypes;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public static class AsyncHistorySessionData {
        protected Map<String, List<ObjectNode>> jobData = new LinkedHashMap<String, List<ObjectNode>>();

        public Map<String, List<ObjectNode>> getJobData() {
            return this.jobData;
        }

        public void setJobData(Map<String, List<ObjectNode>> jobData) {
            this.jobData = jobData;
        }

        public void addJobData(String type, ObjectNode data) {
            if (!this.jobData.containsKey(type)) {
                this.jobData.put(type, new ArrayList(1));
            }
            this.jobData.get(type).add(data);
        }
    }
}

