/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class SubprocessValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List subProcesses = process.findFlowElementsOfType(SubProcess.class);
        for (SubProcess subProcess : subProcesses) {
            if (subProcess instanceof EventSubProcess) continue;
            List startEvents = process.findFlowElementsInSubProcessOfType(subProcess, StartEvent.class, false);
            if (startEvents.size() > 1) {
                this.addError(errors, "flowable-subprocess-multiple-start-event", process, (BaseElement)subProcess, "Multiple start events not supported for subprocess");
            }
            for (StartEvent startEvent : startEvents) {
                if (startEvent.getEventDefinitions().isEmpty()) continue;
                this.addError(errors, "flowable-subprocess-start-event-event-definition-not-allowed", process, (BaseElement)startEvent, "event definitions only allowed on start event if subprocess is an event subprocess");
            }
        }
    }
}

