/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.flowable.engine.HistoryService;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.impl.HistoricActivityInstanceQueryProperty;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.history.HistoricActivityInstanceQueryRequest;
import org.flowable.rest.service.api.history.HistoricActivityInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricActivityInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<HistoricActivityInstanceResponse> getQueryResponse(HistoricActivityInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        if (queryRequest.getActivityId() != null) {
            query.activityId(queryRequest.getActivityId());
        }
        if (queryRequest.getActivityInstanceId() != null) {
            query.activityInstanceId(queryRequest.getActivityInstanceId());
        }
        if (queryRequest.getActivityName() != null) {
            query.activityName(queryRequest.getActivityName());
        }
        if (queryRequest.getActivityType() != null) {
            query.activityType(queryRequest.getActivityType());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getFinished() != null) {
            Boolean finished = queryRequest.getFinished();
            if (finished.booleanValue()) {
                query.finished();
            } else {
                query.unfinished();
            }
        }
        if (queryRequest.getTaskAssignee() != null) {
            query.taskAssignee(queryRequest.getTaskAssignee());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getTenantId() != null) {
            query.activityTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.activityTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.activityWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryActivityInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(allRequestParams, (PaginateRequest)queryRequest, (Query)query, (String)"startTime", allowedSortProperties, this.restResponseFactory::createHistoricActivityInstanceResponseList);
    }

    static {
        allowedSortProperties.put("activityId", (QueryProperty)HistoricActivityInstanceQueryProperty.ACTIVITY_ID);
        allowedSortProperties.put("activityName", (QueryProperty)HistoricActivityInstanceQueryProperty.ACTIVITY_NAME);
        allowedSortProperties.put("activityType", (QueryProperty)HistoricActivityInstanceQueryProperty.ACTIVITY_TYPE);
        allowedSortProperties.put("duration", (QueryProperty)HistoricActivityInstanceQueryProperty.DURATION);
        allowedSortProperties.put("endTime", (QueryProperty)HistoricActivityInstanceQueryProperty.END);
        allowedSortProperties.put("executionId", (QueryProperty)HistoricActivityInstanceQueryProperty.EXECUTION_ID);
        allowedSortProperties.put("activityInstanceId", (QueryProperty)HistoricActivityInstanceQueryProperty.HISTORIC_ACTIVITY_INSTANCE_ID);
        allowedSortProperties.put("processDefinitionId", (QueryProperty)HistoricActivityInstanceQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricActivityInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("startTime", (QueryProperty)HistoricActivityInstanceQueryProperty.START);
        allowedSortProperties.put("tenantId", (QueryProperty)HistoricActivityInstanceQueryProperty.TENANT_ID);
    }
}

