/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.engine.HistoryService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.QueryVariable;
import org.flowable.rest.service.api.history.HistoricVariableInstanceQueryRequest;
import org.flowable.rest.service.api.history.HistoricVariableInstanceResponse;
import org.flowable.variable.api.history.HistoricVariableInstanceQuery;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoricVariableInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<HistoricVariableInstanceResponse> getQueryResponse(HistoricVariableInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        if (queryRequest.getExcludeTaskVariables() != null && queryRequest.getExcludeTaskVariables().booleanValue()) {
            query.excludeTaskVariables();
        }
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getVariableName() != null) {
            query.variableName(queryRequest.getVariableName());
        }
        if (queryRequest.getVariableNameLike() != null) {
            query.variableNameLike(queryRequest.getVariableNameLike());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryVariableInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)query, (String)"variableName", allowedSortProperties, this.restResponseFactory::createHistoricVariableInstanceResponseList);
    }

    protected void addVariables(HistoricVariableInstanceQuery variableInstanceQuery, List<QueryVariable> variables) {
        block3: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is not supported");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    variableInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block3;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    static {
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("variableName", (QueryProperty)HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
    }
}

