/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseProcessDefinitionResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected ProcessDefinition getProcessDefinitionFromRequest(String processDefinitionId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find a process definition with id '" + processDefinitionId + "'.", ProcessDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessProcessDefinitionById(processDefinition);
        }
        return processDefinition;
    }
}

