/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.properties;

import java.util.EnumMap;
import java.util.Map;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="flowable.admin.app")
public class FlowableAdminAppProperties
implements InitializingBean {
    private String dataSourcePrefix = "";
    private Map<EndpointType, ServerConfig> serverConfig = new EnumMap<EndpointType, ServerConfig>(EndpointType.class);
    @NestedConfigurationProperty
    private final Security security = new Security();

    public String getDataSourcePrefix() {
        return this.dataSourcePrefix;
    }

    public void setDataSourcePrefix(String dataSourcePrefix) {
        this.dataSourcePrefix = dataSourcePrefix;
    }

    public Map<EndpointType, ServerConfig> getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(Map<EndpointType, ServerConfig> serverConfig) {
        this.serverConfig = serverConfig;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void afterPropertiesSet() {
        Encryption encryption = this.getSecurity().getEncryption();
        Assert.notNull((Object)encryption.getCredentialsIVSpec(), (String)"flowable.admin.app.security.encryption.credentials-i-v-spec must be set");
        Assert.notNull((Object)encryption.getCredentialsSecretSpec(), (String)"flowable.admin.app.security.encryption.credentials-secret-spec must be set");
        this.validateServerConfig();
    }

    private void validateServerConfig() {
        for (Map.Entry<EndpointType, ServerConfig> configEntry : this.serverConfig.entrySet()) {
            EndpointType type = configEntry.getKey();
            ServerConfig config = configEntry.getValue();
            String endpointPrefixVariable = "flowable.admin.app.server-config." + type.name().toLowerCase();
            Assert.hasText((String)config.getName(), (String)(endpointPrefixVariable + ".name must be set"));
            Assert.hasText((String)config.getDescription(), (String)(endpointPrefixVariable + ".description must be set"));
            Assert.hasText((String)config.getServerAddress(), (String)(endpointPrefixVariable + ".server-address must be set"));
            Assert.notNull((Object)config.getPort(), (String)(endpointPrefixVariable + ".port must be set"));
            Assert.hasText((String)config.getContextRoot(), (String)(endpointPrefixVariable + ".context-root must be set"));
            Assert.hasText((String)config.getRestRoot(), (String)(endpointPrefixVariable + ".rest-root must be set"));
            Assert.hasText((String)config.getUserName(), (String)(endpointPrefixVariable + ".user-name must be set"));
            Assert.hasText((String)config.getPassword(), (String)(endpointPrefixVariable + ".password must be set"));
        }
    }

    public static class Encryption {
        private String credentialsIVSpec;
        private String credentialsSecretSpec;

        public String getCredentialsIVSpec() {
            return this.credentialsIVSpec;
        }

        public void setCredentialsIVSpec(String credentialsIVSpec) {
            this.credentialsIVSpec = credentialsIVSpec;
        }

        public String getCredentialsSecretSpec() {
            return this.credentialsSecretSpec;
        }

        public void setCredentialsSecretSpec(String credentialsSecretSpec) {
            this.credentialsSecretSpec = credentialsSecretSpec;
        }
    }

    public static class Security {
        @NestedConfigurationProperty
        private final Encryption encryption = new Encryption();
        private boolean preemptiveBasicAuthentication = false;

        public Encryption getEncryption() {
            return this.encryption;
        }

        public boolean isPreemptiveBasicAuthentication() {
            return this.preemptiveBasicAuthentication;
        }

        public void setPreemptiveBasicAuthentication(boolean preemptiveBasicAuthentication) {
            this.preemptiveBasicAuthentication = preemptiveBasicAuthentication;
        }
    }
}

