/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaseDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseDefinitionService.class);
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listCaseDefinitions(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder("cmmn-repository/case-definitions");
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getCaseDefinition(ServerConfig serverConfig, String caseDefinitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "cmmn-repository/case-definitions/" + caseDefinitionId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public CmmnModel getCaseDefinitionModel(ServerConfig serverConfig, String definitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "cmmn-repository/case-definitions/" + definitionId + "/resourcedata"));
        return this.executeRequestForXML((HttpUriRequest)get, serverConfig, 200);
    }

    public JsonNode getCaseDefinitionForms(ServerConfig serverConfig, String caseDefinitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "cmmn-repository/case-definitions/" + caseDefinitionId + "/form-definitions"));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CmmnModel executeRequestForXML(HttpUriRequest request, ServerConfig serverConfig, int expectedStatusCode) {
        Throwable throwable;
        CloseableHttpResponse response;
        FlowableServiceException exception;
        block31: {
            CmmnModel cmmnModel;
            CloseableHttpClient client;
            block32: {
                block33: {
                    boolean success;
                    exception = null;
                    client = this.clientUtil.getHttpClient(serverConfig);
                    response = client.execute(request);
                    throwable = null;
                    InputStream responseContent = response.getEntity().getContent();
                    XMLInputFactory xif = XMLInputFactory.newInstance();
                    InputStreamReader in = new InputStreamReader(responseContent, StandardCharsets.UTF_8);
                    XMLStreamReader xtr = xif.createXMLStreamReader(in);
                    CmmnModel cmmmnModel = new CmmnXmlConverter().convertToCmmnModel(xtr);
                    boolean bl = success = response.getStatusLine() != null && response.getStatusLine().getStatusCode() == expectedStatusCode;
                    if (!success) break block31;
                    cmmnModel = cmmmnModel;
                    if (response == null) break block32;
                    if (throwable == null) break block33;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block32;
                }
                response.close();
            }
            try {
                client.close();
                return cmmnModel;
            }
            catch (Exception e) {
                LOGGER.warn("Error closing http client instance", (Throwable)e);
            }
            return cmmnModel;
        }
        try {
            try {
                exception = new FlowableServiceException("An error occurred while calling Flowable: " + response.getStatusLine());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
            exception = this.clientUtil.wrapException(e, request);
        }
        if (exception == null) return null;
        throw exception;
    }
}

