/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DecisionTableDeploymentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionTableDeploymentService.class);
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listDeployments(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = null;
        try {
            builder = new URIBuilder("dmn-repository/deployments");
        }
        catch (Exception e) {
            LOGGER.error("Error building uri", (Throwable)e);
            throw new FlowableServiceException("Error building uri", e);
        }
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getDeployment(ServerConfig serverConfig, String deploymentId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "dmn-repository/deployments/" + deploymentId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public void deleteDeployment(ServerConfig serverConfig, HttpServletResponse httpResponse, String appDeploymentId) {
        HttpDelete delete = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, this.clientUtil.createUriBuilder("dmn-repository/deployments/" + appDeploymentId)));
        this.clientUtil.execute((HttpUriRequest)delete, httpResponse, serverConfig);
    }

    public JsonNode uploadDeployment(ServerConfig serverConfig, String name, InputStream inputStream) throws IOException {
        HttpPost post = new HttpPost(this.clientUtil.getServerUrl(serverConfig, "dmn-repository/deployments"));
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody(name, IOUtils.toByteArray((InputStream)inputStream), ContentType.APPLICATION_OCTET_STREAM, name).build();
        post.setEntity(reqEntity);
        return this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig, 201);
    }
}

