/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import org.fluentlenium.adapter.FluentAdapter;
import org.fluentlenium.adapter.util.CookieStrategyReader;
import org.fluentlenium.adapter.util.DefaultCookieStrategyReader;
import org.fluentlenium.adapter.util.DefaultSharedDriverStrategyReader;
import org.fluentlenium.adapter.util.SharedDriverOnceShutdownHook;
import org.fluentlenium.adapter.util.SharedDriverStrategy;
import org.fluentlenium.adapter.util.SharedDriverStrategyReader;
import org.fluentlenium.core.Fluent;
import org.openqa.selenium.WebDriver;

public class FluentTestRunnerAdapter
extends FluentAdapter {
    private static WebDriver sharedDriver;
    private static boolean isSharedDriverPerClass;
    private final SharedDriverStrategyReader sdsr;
    private final CookieStrategyReader csr;

    public FluentTestRunnerAdapter() {
        this(new DefaultSharedDriverStrategyReader(), new DefaultCookieStrategyReader());
    }

    public FluentTestRunnerAdapter(SharedDriverStrategyReader sharedDriverExtractor, CookieStrategyReader cookieExtractor) {
        this.sdsr = sharedDriverExtractor;
        this.csr = cookieExtractor;
    }

    protected void starting() {
        this.starting(this.getClass());
    }

    protected void starting(String testName) {
        this.starting(this.getClass(), testName);
    }

    protected void starting(Class<?> testClass) {
        this.starting(testClass, testClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void starting(Class<?> testClass, String testName) {
        SharedDriverStrategy strategy = this.sdsr.getSharedDriverStrategy(testClass, testName);
        if (strategy == SharedDriverStrategy.ONCE) {
            FluentTestRunnerAdapter fluentTestRunnerAdapter = this;
            synchronized (fluentTestRunnerAdapter) {
                if (sharedDriver == null) {
                    this.initFluent(this.getDefaultDriver()).withDefaultUrl(this.getDefaultBaseUrl());
                    sharedDriver = this.getDriver();
                    Runtime.getRuntime().addShutdownHook(new SharedDriverOnceShutdownHook("SharedDriver-ONCE-ShutdownHook"));
                } else {
                    this.initFluent(sharedDriver).withDefaultUrl(this.getDefaultBaseUrl());
                }
            }
        } else if (strategy == SharedDriverStrategy.PER_CLASS) {
            FluentTestRunnerAdapter fluentTestRunnerAdapter = this;
            synchronized (fluentTestRunnerAdapter) {
                if (!isSharedDriverPerClass) {
                    this.initFluent(this.getDefaultDriver()).withDefaultUrl(this.getDefaultBaseUrl());
                    sharedDriver = this.getDriver();
                    isSharedDriverPerClass = true;
                } else {
                    this.initFluent(sharedDriver).withDefaultUrl(this.getDefaultBaseUrl());
                }
            }
        } else {
            this.initFluent(this.getDefaultDriver()).withDefaultUrl(this.getDefaultBaseUrl());
        }
        this.init();
    }

    protected void finished() {
        this.finished(this.getClass());
    }

    protected void finished(String testName) {
        this.finished(this.getClass(), testName);
    }

    protected void finished(Class<?> testClass) {
        this.finished(testClass, testClass.getName());
    }

    protected void finished(Class<?> testClass, String testName) {
        this.close();
        SharedDriverStrategy strategy = this.sdsr.getSharedDriverStrategy(testClass, testName);
        if (strategy == SharedDriverStrategy.PER_METHOD) {
            this.quit();
        } else if (sharedDriver != null && this.csr.shouldDeleteCookies(testClass, testName)) {
            sharedDriver.manage().deleteAllCookies();
        }
    }

    protected void failed() {
        this.failed(this.getClass());
    }

    protected void failed(String testName) {
        this.failed(null, this.getClass(), testName);
    }

    protected void failed(Class<?> testClass) {
        this.failed(null, testClass, testClass.getName());
    }

    protected void failed(Class<?> testClass, String testName) {
        this.failed(null, testClass, testName);
    }

    protected void failed(Throwable e, Class<?> testClass, String testName) {
        if (this.screenshotMode == Fluent.TriggerMode.ON_FAIL) {
            this.takeScreenShot(testClass.getSimpleName() + "_" + testName + ".png");
        }
        if (this.htmlDumpMode == Fluent.TriggerMode.ON_FAIL) {
            this.takeHtmlDump(testClass.getSimpleName() + "_" + testName + ".html");
        }
    }

    public static void releaseSharedDriver() {
        if (isSharedDriverPerClass) {
            sharedDriver.quit();
            sharedDriver = null;
            isSharedDriverPerClass = false;
        }
    }
}

