/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.fluentlenium.core.Alert;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.action.FillConstructor;
import org.fluentlenium.core.action.FillSelectConstructor;
import org.fluentlenium.core.action.FluentDefaultActions;
import org.fluentlenium.core.domain.FluentJavascript;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.page.PageInitializer;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchActions;
import org.fluentlenium.core.wait.FluentWait;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public abstract class Fluent
implements SearchActions<FluentWebElement> {
    private String baseUrl;
    private ThreadLocal<WebDriver> webDriverThreadLocal = new ThreadLocal();
    private ThreadLocal<Search> searchThreadLocal = new ThreadLocal();
    private String htmlDumpPath;
    private String screenshotPath;
    protected TriggerMode screenshotMode = TriggerMode.NEVER;
    protected TriggerMode htmlDumpMode = TriggerMode.NEVER;
    private EventsRegistry events = null;
    protected PageInitializer pageInitializer = new PageInitializer(this);

    public Fluent(WebDriver driver) {
        this.webDriverThreadLocal.set(driver);
        this.searchThreadLocal.set(new Search((SearchContext)driver));
    }

    public Fluent withDefaultUrl(String baseUrl) {
        if (baseUrl != null) {
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            this.baseUrl = baseUrl;
        }
        return this;
    }

    public Fluent withDefaultPageWait(long l, TimeUnit timeUnit) {
        this.getDriver().manage().timeouts().pageLoadTimeout(l, timeUnit);
        return this;
    }

    public Fluent withDefaultSearchWait(long l, TimeUnit timeUnit) {
        this.getDriver().manage().timeouts().implicitlyWait(l, timeUnit);
        return this;
    }

    public Fluent() {
    }

    public void setScreenshotPath(String path) {
        this.screenshotPath = path;
    }

    public void setHtmlDumpPath(String htmlDumpPath) {
        this.htmlDumpPath = htmlDumpPath;
    }

    public void setScreenshotMode(TriggerMode mode) {
        this.screenshotMode = mode;
    }

    public void setHtmlDumpMode(TriggerMode htmlDumpMode) {
        this.htmlDumpMode = htmlDumpMode;
    }

    public Fluent takeHtmlDump() {
        return this.takeHtmlDump(new Date().getTime() + ".html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fluent takeHtmlDump(String fileName) {
        File destFile = null;
        try {
            destFile = this.htmlDumpPath != null ? Paths.get(this.htmlDumpPath, fileName).toFile() : new File(fileName);
            Class<Fluent> clazz = Fluent.class;
            synchronized (Fluent.class) {
                String html = this.findFirst("html", new Filter[0]).html();
                // ** MonitorExit[var4_3] (shouldn't be in output)
                FileUtils.write((File)destFile, (CharSequence)html, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            if (destFile == null) {
                destFile = new File(fileName);
            }
            try {
                PrintWriter printWriter = new PrintWriter(destFile, "UTF-8");
                printWriter.write("Can't dump HTML");
                printWriter.println();
                e.printStackTrace(printWriter);
                IOUtils.closeQuietly((Writer)printWriter);
            }
            catch (IOException e1) {
                throw new RuntimeException("error when dumping HTML", e);
            }
        }
        return this;
    }

    public Fluent takeScreenShot() {
        return this.takeScreenShot(new Date().getTime() + ".png");
    }

    public Fluent takeScreenShot(String fileName) {
        if (!(this.getDriver() instanceof TakesScreenshot)) {
            throw new WebDriverException("Current browser doesn't allow taking screenshot.");
        }
        File scrFile = (File)((TakesScreenshot)this.getDriver()).getScreenshotAs(OutputType.FILE);
        try {
            File destFile = this.screenshotPath != null ? Paths.get(this.screenshotPath, fileName).toFile() : new File(fileName);
            FileUtils.copyFile((File)scrFile, (File)destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error when taking the snapshot", e);
        }
        FileUtils.deleteQuietly((File)scrFile);
        return this;
    }

    protected Fluent initFluent(WebDriver driver) {
        this.webDriverThreadLocal.set(driver);
        this.searchThreadLocal.set(new Search((SearchContext)driver));
        if (driver instanceof EventFiringWebDriver) {
            this.events = new EventsRegistry((EventFiringWebDriver)driver);
        }
        return this;
    }

    public WebDriver getDriver() {
        return this.webDriverThreadLocal.get();
    }

    public Search getSearch() {
        return this.searchThreadLocal.get();
    }

    public EventsRegistry events() {
        if (this.events == null) {
            throw new IllegalStateException("An EventFiringWebDriver instance is required to use events. Please override getDefaultDriver() to provide it.");
        }
        return this.events;
    }

    public <T extends FluentPage> T createPage(Class<T> cls, Object ... params) {
        return this.pageInitializer.createPage(cls, params);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public FluentWait await() {
        return new FluentWait(this, this.getSearch());
    }

    public String title() {
        return this.getDriver().getTitle();
    }

    public Set<Cookie> getCookies() {
        return this.getDriver().manage().getCookies();
    }

    public Cookie getCookie(String name) {
        return this.getDriver().manage().getCookieNamed(name);
    }

    public String url() {
        String currentUrl = this.getDriver().getCurrentUrl();
        if (currentUrl != null && this.baseUrl != null && currentUrl.startsWith(this.baseUrl)) {
            currentUrl = currentUrl.substring(this.baseUrl.length());
        }
        return currentUrl;
    }

    public String pageSource() {
        return this.getDriver().getPageSource();
    }

    public <P extends FluentPage> P goTo(P page) {
        if (page == null) {
            throw new IllegalArgumentException("Page is mandatory");
        }
        page.go();
        return page;
    }

    public Fluent goTo(String url) {
        URI uri;
        if (url == null) {
            throw new IllegalArgumentException("Url is mandatory");
        }
        if (this.baseUrl != null && !(uri = URI.create(url)).isAbsolute()) {
            url = this.baseUrl + url;
        }
        this.getDriver().get(url);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fluent goToInNewTab(String url) {
        String newTab;
        URI uri;
        if (url == null) {
            throw new IllegalArgumentException("Url is mandatory");
        }
        if (this.baseUrl != null && !(uri = URI.create(url)).isAbsolute()) {
            url = this.baseUrl + url;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Set initialTabs = this.getDriver().getWindowHandles();
            this.executeScript("window.open('" + url + "', '_blank');", new Object[0]);
            Set tabs = this.getDriver().getWindowHandles();
            tabs.removeAll(initialTabs);
            newTab = (String)tabs.iterator().next();
        }
        this.getDriver().switchTo().window(newTab);
        return this;
    }

    public FluentJavascript executeScript(String script, Object ... args) {
        return new FluentJavascript(this.getDriver(), false, script, args);
    }

    public FluentJavascript executeAsyncScript(String script, Object ... args) {
        return new FluentJavascript(this.getDriver(), true, script, args);
    }

    public FluentList<FluentWebElement> $(String name, Filter ... filters) {
        return this.getSearch().find(name, filters);
    }

    public FluentList<FluentWebElement> $(Filter ... filters) {
        return this.getSearch().find(filters);
    }

    public FluentList<FluentWebElement> $(By locator, Filter ... filters) {
        return this.getSearch().find(locator, filters);
    }

    public FluentWebElement $(String name, Integer number, Filter ... filters) {
        return this.getSearch().find(name, number, filters);
    }

    public FluentWebElement $(By locator, Integer number, Filter ... filters) {
        return this.getSearch().find(locator, number, filters);
    }

    public FluentWebElement $(Integer number, Filter ... filters) {
        return this.getSearch().find(number, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String name, Filter ... filters) {
        return this.getSearch().find(name, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(By locator, Filter ... filters) {
        return this.getSearch().find(locator, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(Filter ... filters) {
        return this.getSearch().find(filters);
    }

    @Override
    public FluentWebElement find(String name, Integer number, Filter ... filters) {
        return this.getSearch().find(name, number, filters);
    }

    @Override
    public FluentWebElement find(By locator, Integer number, Filter ... filters) {
        return this.getSearch().find(locator, number, filters);
    }

    @Override
    public FluentWebElement find(Integer number, Filter ... filters) {
        return this.getSearch().find(number, filters);
    }

    @Override
    public FluentWebElement findFirst(String name, Filter ... filters) {
        return this.getSearch().findFirst(name, filters);
    }

    @Override
    public FluentWebElement findFirst(Filter ... filters) {
        return this.getSearch().findFirst(filters);
    }

    @Override
    public FluentWebElement findFirst(By locator, Filter ... filters) {
        return this.getSearch().findFirst(locator, filters);
    }

    public FillConstructor fill(String cssSelector, Filter ... filters) {
        return new FillConstructor(cssSelector, this.getDriver(), filters);
    }

    public FillConstructor fill(Filter ... filters) {
        return new FillConstructor(this.getDriver(), filters);
    }

    public FillConstructor fill(FluentDefaultActions list, Filter ... filters) {
        return new FillConstructor(list, this.getDriver(), filters);
    }

    public FillSelectConstructor fillSelect(String cssSelector, Filter ... filters) {
        return new FillSelectConstructor(cssSelector, this.getDriver(), filters);
    }

    public FillSelectConstructor fillSelect(Filter ... filters) {
        return new FillSelectConstructor(this.getDriver(), filters);
    }

    public Fluent click(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).click();
        return this;
    }

    public Fluent click(Filter ... filters) {
        this.$(filters).click();
        return this;
    }

    public Fluent clear(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).clear();
        return this;
    }

    public Fluent clear(Filter ... filters) {
        this.$(filters).clear();
        return this;
    }

    public Fluent submit(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).submit();
        return this;
    }

    public Fluent submit(Filter ... filters) {
        this.$(filters).submit();
        return this;
    }

    public List<String> text(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getTexts();
    }

    public List<String> text(Filter ... filters) {
        return this.$(filters).getTexts();
    }

    public List<String> value(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getValues();
    }

    public List<String> value(Filter ... filters) {
        return this.$(filters).getValues();
    }

    public Fluent click(FluentDefaultActions fluentObject) {
        fluentObject.click();
        return this;
    }

    public Fluent clear(FluentList<FluentWebElement> fluentObject) {
        fluentObject.clear();
        return this;
    }

    public Fluent clear(FluentWebElement fluentObject) {
        fluentObject.clear();
        return this;
    }

    public Fluent submit(FluentDefaultActions fluentObject) {
        fluentObject.submit();
        return this;
    }

    public Fluent switchTo(FluentWebElement element) {
        if (null == element || !"iframe".equals(element.getTagName())) {
            this.getDriver().switchTo().defaultContent();
        } else {
            this.getDriver().switchTo().frame(element.getElement());
        }
        return this;
    }

    public Fluent switchTo() {
        this.switchTo(null);
        return this;
    }

    public Fluent switchToDefault() {
        this.switchTo(null);
        return this;
    }

    public Alert alert() {
        return new Alert(this.getDriver());
    }

    public Fluent maximizeWindow() {
        this.getDriver().manage().window().maximize();
        return this;
    }

    public void quit() {
        if (this.getDriver() != null) {
            this.getDriver().quit();
        }
        this.cleanupDriver();
    }

    public void cleanupDriver() {
        this.webDriverThreadLocal.remove();
        this.searchThreadLocal.remove();
    }

    protected static enum TriggerMode {
        ON_FAIL,
        NEVER;

    }
}

