/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.axes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.domain.FluentWebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class Axes {
    private final WebElement webElement;

    public Axes(WebElement element) {
        this.webElement = element;
    }

    public FluentWebElement parent() {
        WebElement parentRaw = this.webElement.findElement(By.xpath((String)"parent::*"));
        FluentWebElement parent = new FluentWebElement(parentRaw);
        return parent;
    }

    protected FluentList<FluentWebElement> handleAxe(String axe) {
        List ancestorsRaw = this.webElement.findElements(By.xpath((String)(axe + "::*")));
        ArrayList<FluentWebElement> elements = new ArrayList<FluentWebElement>();
        for (WebElement ancestor : ancestorsRaw) {
            elements.add(new FluentWebElement(ancestor));
        }
        return new FluentListImpl<FluentWebElement>((Collection<FluentWebElement>)elements);
    }

    public FluentList<FluentWebElement> ancestors() {
        return this.handleAxe("ancestor");
    }

    public FluentList<FluentWebElement> descendants() {
        return this.handleAxe("descendant");
    }

    public FluentList<FluentWebElement> followings() {
        return this.handleAxe("following");
    }

    public FluentList<FluentWebElement> followingSiblings() {
        return this.handleAxe("following-sibling");
    }

    public FluentList<FluentWebElement> precedings() {
        return this.handleAxe("preceding");
    }

    public FluentList<FluentWebElement> precedingSiblings() {
        return this.handleAxe("preceding-sibling");
    }
}

