/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import java.lang.reflect.Constructor;
import org.fluentlenium.core.FluentThread;
import org.fluentlenium.core.action.FillConstructor;
import org.fluentlenium.core.action.FillSelectConstructor;
import org.fluentlenium.core.action.FluentDefaultActions;
import org.fluentlenium.core.action.MouseActions;
import org.fluentlenium.core.axes.Axes;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchActions;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;

public class FluentWebElement
implements FluentDefaultActions<FluentWebElement>,
SearchActions<FluentWebElement> {
    private final WebElement webElement;
    private final Search search;
    private final Axes axes;

    public FluentWebElement(WebElement webElement) {
        this.webElement = webElement;
        this.search = new Search((SearchContext)webElement);
        this.axes = new Axes(webElement);
    }

    @Override
    public FluentWebElement click() {
        this.webElement.click();
        return this;
    }

    public Axes axes() {
        return this.axes;
    }

    public <T> T as(Class<T> componentClass) {
        try {
            Constructor<T> constructor = componentClass.getConstructor(WebElement.class);
            return constructor.newInstance(this.getElement());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(componentClass.getName() + " is not a valid component class. It should have a single WebElement parameter constructor.", e);
        }
    }

    public FluentWebElement doubleClick() {
        MouseActions mouseActions = new MouseActions(FluentThread.get().getDriver());
        Action action = mouseActions.doubleClick(this.webElement);
        action.perform();
        return this;
    }

    public FluentWebElement mouseOver() {
        MouseActions mouseActions = new MouseActions(FluentThread.get().getDriver());
        Action action = mouseActions.mouseOver(this.webElement);
        action.perform();
        return this;
    }

    public FluentWebElement clear() {
        if (!this.isInputOfTypeFile()) {
            this.webElement.clear();
        }
        return this;
    }

    @Override
    public FluentWebElement submit() {
        this.webElement.submit();
        return this;
    }

    @Override
    public FluentWebElement text(String ... text) {
        this.clear();
        if (text.length != 0) {
            this.webElement.sendKeys(new CharSequence[]{text[0]});
        }
        return this;
    }

    public String getName() {
        return this.webElement.getAttribute("name");
    }

    public String getAttribute(String attribute) {
        return this.webElement.getAttribute(attribute);
    }

    public String getId() {
        return this.webElement.getAttribute("id");
    }

    public String getText() {
        return this.webElement.getText();
    }

    public String getTextContent() {
        return this.webElement.getAttribute("textContent");
    }

    public String getValue() {
        return this.webElement.getAttribute("value");
    }

    public boolean isDisplayed() {
        return this.webElement.isDisplayed();
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public boolean isSelected() {
        return this.webElement.isSelected();
    }

    public String getTagName() {
        return this.webElement.getTagName();
    }

    public WebElement getElement() {
        return this.webElement;
    }

    public Dimension getSize() {
        return this.webElement.getSize();
    }

    @Override
    public FluentList<FluentWebElement> find(By locator, Filter ... filters) {
        return this.search.find(locator, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(Filter ... filters) {
        return this.search.find(filters);
    }

    @Override
    public FluentWebElement find(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    @Override
    public FluentWebElement find(By locator, Integer number, Filter ... filters) {
        return this.search.find(locator, number, filters);
    }

    @Override
    public FluentWebElement find(Integer number, Filter ... filters) {
        return this.search.find(number, filters);
    }

    @Override
    public FluentWebElement findFirst(String name, Filter ... filters) {
        return this.search.findFirst(name, filters);
    }

    @Override
    public FluentWebElement findFirst(By locator, Filter ... filters) {
        return this.search.findFirst(locator, filters);
    }

    @Override
    public FluentWebElement findFirst(Filter ... filters) {
        return this.search.findFirst(filters);
    }

    public String html() {
        return this.webElement.getAttribute("innerHTML");
    }

    public FillConstructor fill() {
        return new FillConstructor(this, FluentThread.get().getDriver(), new Filter[0]);
    }

    public FillSelectConstructor fillSelect() {
        return new FillSelectConstructor(this, FluentThread.get().getDriver(), new Filter[0]);
    }

    private boolean isInputOfTypeFile() {
        return "input".equalsIgnoreCase(this.getTagName()) && "file".equalsIgnoreCase(this.getAttribute("type"));
    }

    public String toString() {
        return this.getElement().toString();
    }
}

