/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.core.events.ElementListener;
import org.fluentlenium.core.events.EventAdapter;
import org.fluentlenium.core.events.EventListener;
import org.fluentlenium.core.events.EventsSupport;
import org.fluentlenium.core.events.ExceptionListener;
import org.fluentlenium.core.events.FindByListener;
import org.fluentlenium.core.events.NavigateAllListener;
import org.fluentlenium.core.events.NavigateListener;
import org.fluentlenium.core.events.NavigateToListener;
import org.fluentlenium.core.events.ScriptListener;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class EventsRegistry {
    private final EventFiringWebDriver eventDriver;
    private final EventsSupport support;
    List<NavigateToListener> beforeNavigateTo = new ArrayList<NavigateToListener>();
    List<NavigateToListener> afterNavigateTo = new ArrayList<NavigateToListener>();
    List<NavigateListener> beforeNavigateBack = new ArrayList<NavigateListener>();
    List<NavigateListener> afterNavigateBack = new ArrayList<NavigateListener>();
    List<NavigateListener> beforeNavigateForward = new ArrayList<NavigateListener>();
    List<NavigateListener> afterNavigateForward = new ArrayList<NavigateListener>();
    List<NavigateAllListener> beforeNavigate = new ArrayList<NavigateAllListener>();
    List<NavigateAllListener> afterNavigate = new ArrayList<NavigateAllListener>();
    List<NavigateListener> beforeNavigateRefresh = new ArrayList<NavigateListener>();
    List<NavigateListener> afterNavigateRefresh = new ArrayList<NavigateListener>();
    List<FindByListener> beforeFindBy = new ArrayList<FindByListener>();
    List<FindByListener> afterFindBy = new ArrayList<FindByListener>();
    List<ElementListener> beforeClickOn = new ArrayList<ElementListener>();
    List<ElementListener> afterClickOn = new ArrayList<ElementListener>();
    List<ElementListener> beforeChangeValueOf = new ArrayList<ElementListener>();
    List<ElementListener> afterChangeValueOf = new ArrayList<ElementListener>();
    List<ScriptListener> beforeScript = new ArrayList<ScriptListener>();
    List<ScriptListener> afterScript = new ArrayList<ScriptListener>();
    List<ExceptionListener> onException = new ArrayList<ExceptionListener>();

    public EventsRegistry(EventFiringWebDriver driver) {
        this.eventDriver = driver;
        this.support = new EventsSupport(this);
        this.register(this.support);
    }

    public EventsRegistry register(EventListener eventListener) {
        this.eventDriver.register((WebDriverEventListener)new EventAdapter(eventListener));
        return this;
    }

    public EventsRegistry unregister(EventListener eventListener) {
        this.eventDriver.unregister((WebDriverEventListener)new EventAdapter(eventListener));
        return this;
    }

    public WebDriver getWrappedDriver() {
        return this.eventDriver.getWrappedDriver();
    }

    public EventsRegistry beforeNavigateTo(NavigateToListener listener) {
        this.beforeNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateTo(NavigateToListener listener) {
        this.afterNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateBack(NavigateListener listener) {
        this.beforeNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateBack(NavigateListener listener) {
        this.afterNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateForward(NavigateListener listener) {
        this.beforeNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateForward(NavigateListener listener) {
        this.afterNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigate(NavigateAllListener listener) {
        this.beforeNavigate.add(listener);
        return this;
    }

    public EventsRegistry afterNavigate(NavigateAllListener listener) {
        this.afterNavigate.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateRefresh(NavigateListener listener) {
        this.beforeNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateRefresh(NavigateListener listener) {
        this.afterNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry beforeFindBy(FindByListener listener) {
        this.beforeFindBy.add(listener);
        return this;
    }

    public EventsRegistry afterFindBy(FindByListener listener) {
        this.afterFindBy.add(listener);
        return this;
    }

    public EventsRegistry beforeClickOn(ElementListener listener) {
        this.beforeClickOn.add(listener);
        return this;
    }

    public EventsRegistry afterClickOn(ElementListener listener) {
        this.afterClickOn.add(listener);
        return this;
    }

    public EventsRegistry beforeChangeValueOf(ElementListener listener) {
        this.beforeChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry afterChangeValueOf(ElementListener listener) {
        this.afterChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry beforeScript(ScriptListener listener) {
        this.beforeScript.add(listener);
        return this;
    }

    public EventsRegistry afterScript(ScriptListener listener) {
        this.afterScript.add(listener);
        return this;
    }

    public EventsRegistry onException(ExceptionListener listener) {
        this.onException.add(listener);
        return this;
    }
}

