/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.filter.matcher.Matcher;

public class Filter {
    private final String attribut;
    private final Matcher matcher;

    public Filter(FilterType filterType, String value) {
        this.attribut = filterType.name();
        this.matcher = new EqualMatcher(value);
    }

    public Filter(FilterType filterType, Matcher matcher) {
        this.attribut = filterType.name();
        this.matcher = matcher;
    }

    public Filter(String customAttribute, String value) {
        this.attribut = customAttribute;
        this.matcher = new EqualMatcher(value);
    }

    public Filter(String customAttribute, Matcher matcher) {
        this.attribut = customAttribute;
        this.matcher = matcher;
    }

    public String getAttribut() {
        return this.attribut.toLowerCase();
    }

    public String toString() {
        String matcherAttribute = this.matcher != null ? this.matcher.getMatcherSymbol() : "";
        return "[" + this.attribut.toLowerCase() + matcherAttribute + "=\"" + this.matcher.getValue() + "\"]";
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public boolean isPreFilter() {
        return this.matcher != null && this.matcher.isPreFilter() && !FilterType.TEXT.name().equalsIgnoreCase(this.getAttribut());
    }
}

