/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.page;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.fluentlenium.adapter.FluentAdapter;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.annotation.AjaxElement;
import org.fluentlenium.core.annotation.Page;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.page.PageInitializerException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;

public class PageInitializer {
    private final ConcurrentMap<Class, FluentPage> pageInstances = new ConcurrentHashMap<Class, FluentPage>();
    private final Fluent fluent;

    public PageInitializer(Fluent fluent) {
        this.fluent = fluent;
    }

    public void release() {
        this.pageInstances.clear();
    }

    public <T extends FluentPage> T createPage(Class<T> cls, Object ... params) {
        Class<T> container = this.initClass((T)((Object)cls), params);
        try {
            this.initContainer((Fluent)((Object)container));
        }
        catch (ClassNotFoundException e) {
            throw new PageInitializerException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new PageInitializerException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
        return (T)container;
    }

    public void initContainer(Fluent container) throws IllegalAccessException, ClassNotFoundException {
        this.injectPageIntoContainer(container);
        this.initFluentWebElements(container);
        PageFactory.initElements((WebDriver)container.getDriver(), (Object)container);
    }

    private void injectPageIntoContainer(Fluent container) throws ClassNotFoundException, IllegalAccessException {
        Class<?> cls = container.getClass();
        while (FluentAdapter.class.isAssignableFrom(cls) || FluentPage.class.isAssignableFrom(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Page.class)) continue;
                field.setAccessible(true);
                Class<?> clsField = field.getType();
                Class<?> clsPage = Class.forName(clsField.getName());
                Fluent existingPage = (Fluent)this.pageInstances.get(clsPage);
                Object page = (FluentPage)field.get(container);
                if (existingPage != null) {
                    if (page != null) continue;
                    field.set(container, existingPage);
                    continue;
                }
                if (page == null) {
                    page = this.initClass((FluentPage)((Object)clsPage), new Object[0]);
                    field.set(container, page);
                } else {
                    page = this.initClass(page, new Object[0]);
                }
                this.pageInstances.putIfAbsent(clsPage, (FluentPage)page);
                this.initContainer((Fluent)page);
            }
            cls = cls.getSuperclass();
        }
    }

    private <T extends FluentPage> T initClass(Class<T> cls, Object ... params) {
        try {
            T page = this.constructPageWithParams(cls, params);
            this.initClass(page, params);
            return page;
        }
        catch (IllegalAccessException e) {
            throw new PageInitializerException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (NoSuchMethodException e) {
            throw new PageInitializerException("No constructor found on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InstantiationException e) {
            throw new PageInitializerException("Unable to instantiate " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InvocationTargetException e) {
            throw new PageInitializerException("Cannot invoke method setDriver on " + (cls != null ? cls.getName() : " null"), e);
        }
    }

    private <T extends FluentPage> T initClass(T page, Object ... params) {
        try {
            Class<Fluent> parent = Fluent.class;
            this.initDriver(page, parent);
            this.initBaseUrl(page, parent);
            return page;
        }
        catch (IllegalAccessException e) {
            throw new PageInitializerException("IllegalAccessException on class " + page.getClass().getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new PageInitializerException("No constructor found on class " + page.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new PageInitializerException("Cannot invoke method setDriver on " + page.getClass().getName(), e);
        }
    }

    private <T extends Fluent> void initFluentWebElements(T page) {
        Class<?> classz = page.getClass();
        while (FluentAdapter.class.isAssignableFrom(classz) || FluentPage.class.isAssignableFrom(classz)) {
            for (Field fieldFromPage : classz.getDeclaredFields()) {
                if (!this.isFluentWebElementField(fieldFromPage)) continue;
                fieldFromPage.setAccessible(true);
                AjaxElement elem = fieldFromPage.getAnnotation(AjaxElement.class);
                if (elem == null) {
                    PageInitializer.proxyElement((ElementLocatorFactory)new DefaultElementLocatorFactory((SearchContext)this.fluent.getDriver()), page, fieldFromPage);
                    continue;
                }
                PageInitializer.proxyElement((ElementLocatorFactory)new AjaxElementLocatorFactory((SearchContext)this.fluent.getDriver(), elem.timeOutInSeconds()), page, fieldFromPage);
            }
            classz = classz.getSuperclass();
        }
    }

    private boolean isFluentWebElementField(Field field) {
        try {
            return !Modifier.isFinal(field.getModifiers()) && (PageInitializer.isFluentList(field) || field.getType().getConstructor(WebElement.class) != null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isFluentList(Field field) {
        return FluentList.class.isAssignableFrom(field.getType());
    }

    private <T extends FluentPage> T constructPageWithParams(Class<T> cls, Object[] params) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] classTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            classTypes[i] = params[i].getClass();
        }
        try {
            Constructor<T> construct = cls.getDeclaredConstructor(classTypes);
            construct.setAccessible(true);
            FluentPage page = (FluentPage)construct.newInstance(params);
            return (T)page;
        }
        catch (NoSuchMethodException ex) {
            if (params.length != 0) {
                throw new PageInitializerException("You provided the wrong arguments to the createPage method, if you just want to use a page with a default constructor, use @Page or createPage(" + cls.getSimpleName() + ".class)", ex);
            }
            throw ex;
        }
    }

    private static Field[] getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields.toArray(new Field[0]);
    }

    private <T extends FluentPage> void initBaseUrl(T page, Class<?> parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.fluent.getBaseUrl() == null) {
            return;
        }
        Method m = parent.getDeclaredMethod("withDefaultUrl", String.class);
        m.setAccessible(true);
        m.invoke(page, this.fluent.getBaseUrl());
    }

    private <T extends FluentPage> void initDriver(T page, Class<?> parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = parent.getDeclaredMethod("initFluent", WebDriver.class);
        m.setAccessible(true);
        m.invoke(page, this.fluent.getDriver());
    }

    private static void proxyElement(ElementLocatorFactory factory, Object page, Field field) {
        ElementLocator locator = factory.createLocator(field);
        if (locator == null) {
            return;
        }
        try {
            field.setAccessible(true);
            if (PageInitializer.isFluentList(field)) {
                FluentListInvocationHandler handler = new FluentListInvocationHandler(locator);
                FluentList proxy = (FluentList)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{FluentList.class}, (InvocationHandler)handler);
                field.set(page, proxy);
            } else {
                LocatingElementHandler handler = new LocatingElementHandler(locator);
                WebElement proxy = (WebElement)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{WebElement.class, Locatable.class}, (InvocationHandler)handler);
                field.set(page, field.getType().getConstructor(WebElement.class).newInstance(proxy));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find an accessible constructor with an argument of type WebElement in " + field.getType(), e);
        }
    }

    private static class FluentListInvocationHandler
    implements InvocationHandler {
        private final ElementLocator elementLocator;

        public FluentListInvocationHandler(ElementLocator elementLocator) {
            this.elementLocator = elementLocator;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            List elements = this.elementLocator.findElements();
            FluentListImpl list = new FluentListImpl(FluentIterable.from((Iterable)elements).transform((Function)new Function<WebElement, FluentWebElement>(){

                public FluentWebElement apply(WebElement input) {
                    return new FluentWebElement(input);
                }
            }).toList());
            try {
                return method.invoke(list, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

