/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.AbstractWaitElementMatcher;
import org.fluentlenium.core.wait.FluentSizeBuilder;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.core.wait.FluentWaitMessages;

public abstract class AbstractWaitElementListMatcher
extends AbstractWaitElementMatcher {
    public AbstractWaitElementListMatcher(Search search, FluentWait wait, String selectionName) {
        super(search, wait, selectionName);
    }

    public void areEnabled() {
        Predicate<Fluent> isEnabled = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                FluentList<? extends FluentWebElement> fluentWebElements = AbstractWaitElementListMatcher.this.find();
                if (fluentWebElements.size() > 0) {
                    for (FluentWebElement fluentWebElement : fluentWebElements) {
                        if (fluentWebElement.isEnabled()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.until(this.wait, isEnabled, FluentWaitMessages.isEnabledMessage(this.selectionName));
    }

    public void areDisplayed() {
        Predicate<Fluent> isVisible = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                FluentList<? extends FluentWebElement> fluentWebElements = AbstractWaitElementListMatcher.this.find();
                if (fluentWebElements.size() > 0) {
                    for (FluentWebElement fluentWebElement : fluentWebElements) {
                        if (fluentWebElement.isDisplayed()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.until(this.wait, isVisible, FluentWaitMessages.isDisplayedMessage(this.selectionName));
    }

    public void areNotDisplayed() {
        Predicate<Fluent> isNotVisible = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                FluentList<? extends FluentWebElement> fluentWebElements = AbstractWaitElementListMatcher.this.find();
                for (FluentWebElement fluentWebElement : fluentWebElements) {
                    if (!fluentWebElement.isDisplayed()) continue;
                    return false;
                }
                return true;
            }
        };
        this.until(this.wait, isNotVisible, FluentWaitMessages.isDisplayedMessage(this.selectionName));
    }

    public FluentSizeBuilder hasSize() {
        return new FluentSizeBuilder(this, this.wait, this.selectionName);
    }

    public void hasSize(final int size) {
        Predicate<Fluent> hasSize = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return AbstractWaitElementListMatcher.this.find().size() == size;
            }
        };
        this.until(this.wait, hasSize, FluentWaitMessages.hasSizeMessage(this.selectionName, size));
    }
}

