/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.AbstractWaitMatcher;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.core.wait.FluentWaitMessages;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;

public abstract class AbstractWaitElementMatcher
extends AbstractWaitMatcher {
    protected Search search;
    protected String selectionName;
    protected FluentWait wait;

    public AbstractWaitElementMatcher(Search search, FluentWait wait, String selectionName) {
        this.selectionName = selectionName;
        this.wait = wait;
        this.search = search;
    }

    public void hasPositionX(final Integer value) {
        Predicate<Fluent> hasPositionX = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                FluentList<? extends FluentWebElement> fluentWebElements = AbstractWaitElementMatcher.this.find();
                for (FluentWebElement fluentWebElement : fluentWebElements) {
                    if (fluentWebElement.getElement().getLocation().getX() != value.intValue()) continue;
                    return true;
                }
                return false;
            }
        };
        this.until(this.wait, hasPositionX, FluentWaitMessages.hasPositionXMessage(this.selectionName, value));
    }

    public void isAboveScreenOrInvisible() {
        Predicate<Fluent> isAbove = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return Iterables.all(AbstractWaitElementMatcher.this.find(), (Predicate)AbstractWaitElementMatcher.this.isAboveScreenTopOrInvisible());
            }
        };
        this.until(this.wait, isAbove, FluentWaitMessages.isAboveMessage(this.find().getIds()));
    }

    private Predicate<FluentWebElement> isAboveScreenTopOrInvisible() {
        return new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement element) {
                WebElement wrapped = element.getElement();
                int bottomPosition = wrapped.getLocation().getY() + wrapped.getSize().getHeight();
                return !element.isDisplayed() || bottomPosition <= 0;
            }
        };
    }

    public void hasAttribute(final String attribute, final String value) {
        Predicate<Fluent> hasAttribute = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return AbstractWaitElementMatcher.this.find().getAttributes(attribute).contains(value);
            }
        };
        this.until(this.wait, hasAttribute, FluentWaitMessages.hasAttributeMessage(this.selectionName, attribute, value));
    }

    public void hasId(final String value) {
        Predicate<Fluent> hasId = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return AbstractWaitElementMatcher.this.find().getIds().contains(value);
            }
        };
        this.until(this.wait, hasId, FluentWaitMessages.hasIdMessage(this.selectionName, value));
    }

    public void hasName(final String value) {
        Predicate<Fluent> hasName = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return AbstractWaitElementMatcher.this.find().getNames().contains(value);
            }
        };
        this.until(this.wait, hasName, FluentWaitMessages.hasNameMessage(this.selectionName, value));
    }

    public void containsText(final String value) {
        Predicate<Fluent> hasText = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                List<String> texts = AbstractWaitElementMatcher.this.find().getTexts();
                if (texts != null) {
                    for (String text : texts) {
                        if (!text.contains(value)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        this.until(this.wait, hasText, FluentWaitMessages.hasTextMessage(this.selectionName, value));
    }

    public void hasText(final String value) {
        Predicate<Fluent> hasText = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return AbstractWaitElementMatcher.this.find().getTexts().contains(value);
            }
        };
        this.until(this.wait, hasText, FluentWaitMessages.hasTextMessage(this.selectionName, value));
    }

    public void isPresent() {
        Predicate<Fluent> isPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                int size = AbstractWaitElementMatcher.this.find().size();
                return size > 0;
            }
        };
        this.until(this.wait, isPresent, FluentWaitMessages.isPresentMessage(this.selectionName));
    }

    public void isNotPresent() {
        Predicate<Fluent> isNotPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return AbstractWaitElementMatcher.this.find().isEmpty();
            }
        };
        this.until(this.wait, isNotPresent, FluentWaitMessages.isNotPresentMessage(this.selectionName));
    }

    public void isDisplayed() {
        Predicate<Fluent> isVisible = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                FluentList<? extends FluentWebElement> fluentWebElements = AbstractWaitElementMatcher.this.find();
                for (FluentWebElement fluentWebElement : fluentWebElements) {
                    if (!fluentWebElement.isDisplayed()) continue;
                    return true;
                }
                return false;
            }
        };
        this.until(this.wait, isVisible, FluentWaitMessages.isDisplayedMessage(this.selectionName));
    }

    public void isNotDisplayed() {
        Predicate<Fluent> isNotVisible = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                FluentList<? extends FluentWebElement> fluentWebElements = AbstractWaitElementMatcher.this.find();
                if (fluentWebElements.size() > 0) {
                    for (FluentWebElement fluentWebElement : fluentWebElements) {
                        if (fluentWebElement.isDisplayed()) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
        this.until(this.wait, isNotVisible, FluentWaitMessages.isDisplayedMessage(this.selectionName));
    }

    public void isEnabled() {
        Predicate<Fluent> isEnabled = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                FluentList<? extends FluentWebElement> fluentWebElements = AbstractWaitElementMatcher.this.find();
                if (fluentWebElements.size() > 0) {
                    for (FluentWebElement fluentWebElement : fluentWebElements) {
                        if (!fluentWebElement.isEnabled()) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
        };
        this.until(this.wait, isEnabled, FluentWaitMessages.isEnabledMessage(this.selectionName));
    }

    public void isClickable() {
        Predicate<Fluent> isClickable = new Predicate<Fluent>(){

            public boolean apply(Fluent input) {
                for (FluentWebElement fluentWebElement : AbstractWaitElementMatcher.this.find()) {
                    if (ExpectedConditions.elementToBeClickable((WebElement)fluentWebElement.getElement()).apply((Object)input.getDriver()) != null) continue;
                    return false;
                }
                return true;
            }
        };
        this.until(this.wait, isClickable, FluentWaitMessages.isClickableMessage(this.selectionName));
    }

    protected abstract FluentList<? extends FluentWebElement> find();
}

