/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.wait.AbstractWaitElementMatcher;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.core.wait.FluentWaitMessages;

public class FluentSizeBuilder {
    private AbstractWaitElementMatcher parent;
    private String selection;
    private FluentWait wait;

    public FluentSizeBuilder(AbstractWaitElementMatcher parent, FluentWait fluentWait, String selection) {
        this.parent = parent;
        this.selection = selection;
        this.wait = fluentWait;
    }

    public void equalTo(final int size) {
        Predicate<Fluent> isPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return FluentSizeBuilder.this.getSize() == size;
            }
        };
        this.parent.until(this.wait, isPresent, FluentWaitMessages.equalToMessage(this.selection, size));
    }

    public void notEqualTo(final int size) {
        Predicate<Fluent> isPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return FluentSizeBuilder.this.getSize() != size;
            }
        };
        this.parent.until(this.wait, isPresent, FluentWaitMessages.notEqualToMessage(this.selection, size));
    }

    public void lessThan(final int size) {
        Predicate<Fluent> isPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return FluentSizeBuilder.this.getSize() < size;
            }
        };
        this.parent.until(this.wait, isPresent, FluentWaitMessages.lessThanMessage(this.selection, size));
    }

    public void lessThanOrEqualTo(final int size) {
        Predicate<Fluent> isPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return FluentSizeBuilder.this.getSize() <= size;
            }
        };
        this.parent.until(this.wait, isPresent, FluentWaitMessages.lessThanOrEqualToMessage(this.selection, size));
    }

    public void greaterThan(final int size) {
        Predicate<Fluent> isPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return FluentSizeBuilder.this.getSize() > size;
            }
        };
        this.parent.until(this.wait, isPresent, FluentWaitMessages.greatherThanMessage(this.selection, size));
    }

    public void greaterThanOrEqualTo(final int size) {
        Predicate<Fluent> isPresent = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return FluentSizeBuilder.this.getSize() >= size;
            }
        };
        this.parent.until(this.wait, isPresent, FluentWaitMessages.greatherThanOrEqualToMessage(this.selection, size));
    }

    private int getSize() {
        return this.parent.find().size();
    }
}

