/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.FluentWaitElementListMatcher;
import org.fluentlenium.core.wait.FluentWaitElementMatcher;
import org.fluentlenium.core.wait.FluentWaitLocatorSelectorMatcher;
import org.fluentlenium.core.wait.FluentWaitPageMatcher;
import org.fluentlenium.core.wait.FluentWaitSupplierListMatcher;
import org.fluentlenium.core.wait.FluentWaitSupplierMatcher;
import org.fluentlenium.core.wait.FluentWaitWindowMatcher;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.Wait;

public class FluentWait
implements Wait<Fluent> {
    private final org.openqa.selenium.support.ui.FluentWait<Fluent> wait;
    private final Search search;
    private final WebDriver driver;
    private boolean useDefaultException;
    private boolean useCustomMessage;

    public org.openqa.selenium.support.ui.FluentWait getWait() {
        return this.wait;
    }

    public FluentWait(Fluent fluent, Search search) {
        this.wait = new org.openqa.selenium.support.ui.FluentWait((Object)fluent);
        this.search = search;
        this.driver = fluent.getDriver();
        this.useDefaultException = true;
    }

    public FluentWait atMost(long duration, TimeUnit unit) {
        this.wait.withTimeout(duration, unit);
        return this;
    }

    public FluentWait atMost(long timeInMillis) {
        this.wait.withTimeout(timeInMillis, TimeUnit.MILLISECONDS);
        return this;
    }

    public FluentWait pollingEvery(long duration, TimeUnit unit) {
        this.wait.pollingEvery(duration, unit);
        return this;
    }

    public FluentWait ignoreAll(Collection<Class<? extends Throwable>> types) {
        this.wait.ignoreAll(types);
        return this;
    }

    public FluentWait ignoring(Class<? extends RuntimeException> exceptionType) {
        this.wait.ignoring(exceptionType);
        return this;
    }

    public FluentWait ignoring(Class<? extends RuntimeException> firstType, Class<? extends RuntimeException> secondType) {
        this.wait.ignoring(firstType, secondType);
        return this;
    }

    @Deprecated
    public void until(Predicate<Fluent> isTrue) {
        this.untilPredicate(isTrue);
    }

    public void untilPredicate(Predicate<Fluent> predicate) {
        this.updateWaitWithDefaultExceptions();
        this.wait.until(predicate);
    }

    public FluentWait withMessage(String message) {
        this.wait.withMessage(message);
        this.useCustomMessage = true;
        return this;
    }

    public FluentWait withNoDefaultsException() {
        this.useDefaultException = false;
        return this;
    }

    public FluentWaitLocatorSelectorMatcher until(String selector) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitLocatorSelectorMatcher(this.search, this, selector);
    }

    public FluentWaitElementMatcher until(FluentWebElement element) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitElementMatcher(this.search, this, element);
    }

    public FluentWaitElementListMatcher until(List<? extends FluentWebElement> elements) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitElementListMatcher(this.search, this, elements);
    }

    public FluentWaitSupplierMatcher untilElement(Supplier<? extends FluentWebElement> selector) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitSupplierMatcher(this.search, this, selector);
    }

    public FluentWaitSupplierListMatcher untilElements(Supplier<? extends FluentList<? extends FluentWebElement>> selector) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitSupplierListMatcher(this.search, this, selector);
    }

    public FluentWaitLocatorSelectorMatcher until(By locator) {
        return new FluentWaitLocatorSelectorMatcher(this.search, this, locator);
    }

    public FluentWaitWindowMatcher untilWindow(String windowName) {
        return new FluentWaitWindowMatcher(this, windowName);
    }

    public FluentWaitPageMatcher untilPage() {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitPageMatcher(this, this.driver);
    }

    public FluentWaitPageMatcher untilPage(FluentPage page) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitPageMatcher(this, this.driver, page);
    }

    public FluentWait explicitlyFor(long amount, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(amount);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void until(final Supplier<Boolean> isTrue) {
        this.updateWaitWithDefaultExceptions();
        this.wait.until((Function)new Function<Object, Boolean>(){

            public Boolean apply(Object input) {
                return (Boolean)isTrue.get();
            }

            public String toString() {
                return isTrue.toString();
            }
        });
    }

    public <T> T until(Function<? super Fluent, T> isTrue) {
        this.updateWaitWithDefaultExceptions();
        return (T)this.wait.until(isTrue);
    }

    private void updateWaitWithDefaultExceptions() {
        if (this.useDefaultException) {
            this.wait.ignoring(StaleElementReferenceException.class);
        }
    }

    public boolean useCustomMessage() {
        return this.useCustomMessage;
    }
}

