/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import java.util.regex.Pattern;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.filter.matcher.ContainsMatcher;
import org.fluentlenium.core.filter.matcher.ContainsWordMatcher;
import org.fluentlenium.core.filter.matcher.EndsWithMatcher;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.filter.matcher.Matcher;
import org.fluentlenium.core.filter.matcher.NotContainsMatcher;
import org.fluentlenium.core.filter.matcher.NotEndsWithMatcher;
import org.fluentlenium.core.filter.matcher.NotStartsWithMatcher;
import org.fluentlenium.core.filter.matcher.StartsWithMatcher;
import org.fluentlenium.core.wait.FluentWaitLocatorSelectorMatcher;

public class FluentWaitFiltersBuilder {
    private FluentWaitLocatorSelectorMatcher fluentLeniumWait;
    private String attribute;

    public FluentWaitFiltersBuilder(FluentWaitLocatorSelectorMatcher fluentWaitBuilder, FilterType filterType) {
        this.fluentLeniumWait = fluentWaitBuilder;
        this.attribute = filterType.name();
    }

    public FluentWaitFiltersBuilder(FluentWaitLocatorSelectorMatcher fluentWaitBuilder, String attribute) {
        this.fluentLeniumWait = fluentWaitBuilder;
        this.attribute = attribute;
    }

    public FluentWaitLocatorSelectorMatcher equalTo(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EqualMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher contains(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new ContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher containsWord(String word) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new ContainsWordMatcher(word)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher contains(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new ContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher startsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher startsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher endsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher endsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher notContains(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher notContains(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher notStartsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher notStartsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher notEndsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitLocatorSelectorMatcher notEndsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }
}

