/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterConstructor;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.AbstractWaitElementListMatcher;
import org.fluentlenium.core.wait.AbstractWaitElementMatcher;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.core.wait.FluentWaitFiltersBuilder;
import org.openqa.selenium.By;

public class FluentWaitLocatorSelectorMatcher
extends AbstractWaitElementListMatcher {
    private By locator;
    private List<Filter> filters = new ArrayList<Filter>();
    static final String SELECTOR = "Selector";

    public FluentWaitLocatorSelectorMatcher(Search search, FluentWait fluentWait, By locator) {
        super(search, fluentWait, "Selector " + locator);
        this.locator = locator;
    }

    public FluentWaitLocatorSelectorMatcher(Search search, FluentWait fluentWait, String selector) {
        super(search, fluentWait, "Selector " + selector);
        this.locator = By.cssSelector((String)selector);
    }

    public FluentWaitFiltersBuilder with(String attribute) {
        return new FluentWaitFiltersBuilder(this, attribute);
    }

    void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    protected String buildMessage(String defaultMessage) {
        StringBuilder message = new StringBuilder(defaultMessage);
        if (this.filters != null && !this.filters.isEmpty()) {
            for (Filter filter : this.filters) {
                message.append(filter.toString());
            }
            message.append(" Filters : ");
        }
        return message.toString();
    }

    protected FluentList<FluentWebElement> find() {
        if (this.filters.size() > 0) {
            return this.findWithFilter();
        }
        return this.search.find(this.locator, new Filter[0]);
    }

    private FluentList<FluentWebElement> findWithFilter() {
        return this.search.find(this.locator, this.filters.toArray(new Filter[this.filters.size()]));
    }

    public FluentWaitFiltersBuilder withId() {
        return new FluentWaitFiltersBuilder(this, FilterType.ID);
    }

    public AbstractWaitElementMatcher withId(String value) {
        this.filters.add(FilterConstructor.withId(value));
        return this;
    }

    public FluentWaitFiltersBuilder withName() {
        return new FluentWaitFiltersBuilder(this, FilterType.NAME);
    }

    public AbstractWaitElementMatcher withName(String value) {
        this.filters.add(FilterConstructor.withName(value));
        return this;
    }

    public FluentWaitFiltersBuilder withClass() {
        return new FluentWaitFiltersBuilder(this, FilterType.CLASS);
    }

    public AbstractWaitElementMatcher withClass(String value) {
        this.filters.add(FilterConstructor.withClass(value));
        return this;
    }

    public FluentWaitFiltersBuilder withText() {
        return new FluentWaitFiltersBuilder(this, FilterType.TEXT);
    }

    public AbstractWaitElementMatcher withText(String value) {
        this.filters.add(FilterConstructor.withText(value));
        return this;
    }
}

