/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.wait.AbstractWaitElementMatcher;
import org.fluentlenium.core.wait.AbstractWaitMatcher;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.core.wait.FluentWaitMessages;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class FluentWaitPageMatcher
extends AbstractWaitMatcher {
    private AbstractWaitElementMatcher parent;
    private FluentWait wait;
    private WebDriver webDriver;
    private FluentPage page;

    public FluentWaitPageMatcher(FluentWait wait, WebDriver driver) {
        this.wait = wait;
        this.webDriver = driver;
    }

    public FluentWaitPageMatcher(FluentWait wait, WebDriver driver, FluentPage page) {
        this.wait = wait;
        this.webDriver = driver;
        this.page = page;
    }

    public void isLoaded() {
        if (!(this.webDriver instanceof JavascriptExecutor)) {
            throw new UnsupportedOperationException("Driver must support javascript execution to use this feature");
        }
        Predicate<Fluent> isLoaded = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                JavascriptExecutor javascriptExecutor = (JavascriptExecutor)fluent.getDriver();
                Object result = javascriptExecutor.executeScript("if (document.readyState) return document.readyState;", new Object[0]);
                return result != null && "complete".equals(result);
            }
        };
        this.until(this.wait, isLoaded, FluentWaitMessages.isPageLoaded(this.webDriver.getCurrentUrl()));
    }

    public void isAt() {
        if (this.page == null) {
            throw new IllegalArgumentException("You should use a page argument when you call the untilPage method to specify the page you want to be. Example : await().untilPage(myPage).isAt();");
        }
        Predicate<Fluent> isLoaded = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                try {
                    FluentWaitPageMatcher.this.page.isAt();
                }
                catch (Error e) {
                    return false;
                }
                return true;
            }
        };
        this.until(this.wait, isLoaded, "");
    }
}

