/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentThread;
import org.fluentlenium.core.wait.AbstractWaitMatcher;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.core.wait.FluentWaitMessages;

public class FluentWaitWindowMatcher
extends AbstractWaitMatcher {
    private FluentWait wait;
    private String windowName;

    public FluentWaitWindowMatcher(FluentWait wait, String windowName) {
        this.wait = wait;
        this.windowName = windowName;
    }

    public Fluent isDisplayed() {
        Predicate<Fluent> isDisplayed = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return fluent.getDriver().getWindowHandles().contains(FluentWaitWindowMatcher.this.windowName);
            }
        };
        this.until(this.wait, isDisplayed, FluentWaitMessages.isWindowDisplayedMessage(this.windowName));
        return FluentThread.get();
    }

    public Fluent isNotDisplayed() {
        Predicate<Fluent> isNotDisplayed = new Predicate<Fluent>(){

            public boolean apply(Fluent fluent) {
                return !fluent.getDriver().getWindowHandles().contains(FluentWaitWindowMatcher.this.windowName);
            }
        };
        this.until(this.wait, isNotDisplayed, FluentWaitMessages.isWindowNotDisplayedMessage(this.windowName));
        return FluentThread.get();
    }
}

