/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.logging.multi;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.internal.logging.multi.MultiLogger;

public class MultiLogCreator
implements LogCreator {
    private final List<LogCreator> logCreators;

    @Override
    public Log createLogger(Class<?> clazz) {
        ArrayList<Log> logs = new ArrayList<Log>();
        for (LogCreator logCreator : this.logCreators) {
            logs.add(logCreator.createLogger(clazz));
        }
        return new MultiLogger(logs);
    }

    public static MultiLogCreator empty() {
        return new MultiLogCreator(new ArrayList<LogCreator>());
    }

    public MultiLogCreator(List<LogCreator> logCreators) {
        this.logCreators = logCreators;
    }
}

