/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.classpath;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.classpath.ClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.DefaultUrlResolver;
import org.flywaydb.core.internal.scanner.classpath.FileSystemClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.JarFileClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.OsgiClassPathLocationScanner;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.scanner.classpath.UrlResolver;
import org.flywaydb.core.internal.scanner.classpath.jboss.JBossVFSv2UrlResolver;
import org.flywaydb.core.internal.scanner.classpath.jboss.JBossVFSv3ClassPathLocationScanner;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.UrlUtils;

public class ClassPathScanner<I>
implements ResourceAndClassScanner<I> {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);
    private final Class<I> implementedInterface;
    private final ClassLoader classLoader;
    private final Location location;
    private final Set<LoadableResource> resources = new HashSet<LoadableResource>();
    private final Map<Location, List<URL>> locationUrlCache = new HashMap<Location, List<URL>>();
    private final LocationScannerCache locationScannerCache;
    private final ResourceNameCache resourceNameCache;
    private final boolean throwOnMissingLocations;

    public ClassPathScanner(Class<I> implementedInterface, ClassLoader classLoader, Charset encoding, Location location, ResourceNameCache resourceNameCache, LocationScannerCache locationScannerCache, boolean throwOnMissingLocations, boolean stream) {
        this.implementedInterface = implementedInterface;
        this.classLoader = classLoader;
        this.location = location;
        this.resourceNameCache = resourceNameCache;
        this.locationScannerCache = locationScannerCache;
        this.throwOnMissingLocations = throwOnMissingLocations;
        LOG.debug("Scanning for classpath resources at '" + String.valueOf(location) + "' ...");
        for (Pair<String, String> resourceNameAndParentURL : this.findResourceNamesAndParentURLs()) {
            String resourceName = resourceNameAndParentURL.getLeft();
            String parentURL = resourceNameAndParentURL.getRight();
            this.resources.add(new ClassPathResource(location, resourceName, classLoader, encoding, parentURL, stream));
            LOG.debug("Found resource: " + resourceNameAndParentURL.getLeft());
        }
    }

    @Override
    public Collection<LoadableResource> scanForResources() {
        return this.resources;
    }

    @Override
    public Collection<Class<? extends I>> scanForClasses() {
        LOG.debug("Scanning for classes at " + String.valueOf(this.location));
        ArrayList<Class<I>> classes = new ArrayList<Class<I>>();
        for (LoadableResource resource : this.resources) {
            Class<I> clazz;
            if (!resource.getAbsolutePath().endsWith(".class")) continue;
            try {
                clazz = ClassUtils.loadClass(this.implementedInterface, this.toClassName(resource.getAbsolutePath()), this.classLoader);
            }
            catch (Throwable e) {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                LOG.warn("Skipping " + String.valueOf(Callback.class) + ": " + ClassUtils.formatThrowable(e) + (String)(rootCause == e ? "" : " caused by " + ClassUtils.formatThrowable(rootCause) + " at " + ExceptionUtils.getThrowLocation(rootCause)));
                clazz = null;
            }
            if (clazz == null) continue;
            classes.add(clazz);
        }
        return classes;
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Pair<String, String>> findResourceNamesAndParentURLs() {
        boolean isClassPathRoot;
        TreeSet<Pair<String, String>> resourceNamesAndParentURLs = new TreeSet<Pair<String, String>>();
        List<URL> locationUrls = this.getLocationUrlsForPath(this.location);
        for (URL locationUrl : locationUrls) {
            LOG.debug("Scanning URL: " + locationUrl.toExternalForm());
            UrlResolver urlResolver = this.createUrlResolver(locationUrl.getProtocol());
            URL resolvedUrl = urlResolver.toStandardJavaUrl(locationUrl);
            String protocol = resolvedUrl.getProtocol();
            ClassPathLocationScanner classPathLocationScanner = this.createLocationScanner(protocol);
            if (classPathLocationScanner == null) {
                String scanRoot = UrlUtils.toFilePath(resolvedUrl);
                LOG.warn("Unable to scan location: " + scanRoot + " (unsupported protocol: " + protocol + ")");
                continue;
            }
            Set<String> names = this.resourceNameCache.get(classPathLocationScanner, resolvedUrl);
            if (names == null) {
                names = classPathLocationScanner.findResourceNames(this.location.getRootPath(), resolvedUrl);
                this.resourceNameCache.put(classPathLocationScanner, resolvedUrl, names);
            }
            HashSet<String> filteredNames = new HashSet<String>();
            for (String name : names) {
                if (!this.location.matchesPath(name)) continue;
                filteredNames.add(name);
            }
            for (String filteredName : filteredNames) {
                resourceNamesAndParentURLs.add(Pair.of(filteredName, resolvedUrl.getPath()));
            }
        }
        boolean locationResolved = !locationUrls.isEmpty();
        boolean bl = isClassPathRoot = this.location.isClassPath() && "".equals(this.location.getRootPath());
        if ((!locationResolved || isClassPathRoot) && this.classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)this.classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                JarFile jarFile;
                if (!"file".equals(url.getProtocol()) || !url.getPath().endsWith(".jar") || url.getPath().matches(".*" + Pattern.quote("/jre/lib/") + ".*")) continue;
                try {
                    try {
                        jarFile = new JarFile(url.toURI().getSchemeSpecificPart());
                    }
                    catch (URISyntaxException ex) {
                        jarFile = new JarFile(url.getPath().substring("file:".length()));
                    }
                }
                catch (IOException | SecurityException e) {
                    LOG.warn("Skipping unloadable jar file: " + String.valueOf(url) + " (" + e.getMessage() + ")");
                    continue;
                }
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String entryName = entries.nextElement().getName();
                        if (!entryName.startsWith(this.location.getRootPath())) continue;
                        locationResolved = true;
                        resourceNamesAndParentURLs.add(Pair.of(entryName, url.getPath()));
                    }
                }
                finally {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!locationResolved) {
            String message = "Unable to resolve location " + String.valueOf(this.location) + ".";
            if (this.throwOnMissingLocations) {
                throw new FlywayException(message);
            }
            LOG.debug(message);
        }
        return resourceNamesAndParentURLs;
    }

    private List<URL> getLocationUrlsForPath(Location location) {
        if (this.locationUrlCache.containsKey(location)) {
            return this.locationUrlCache.get(location);
        }
        LOG.debug("Determining location urls for " + String.valueOf(location) + " using ClassLoader " + String.valueOf(this.classLoader) + " ...");
        ArrayList<URL> locationUrls = new ArrayList<URL>();
        if (this.classLoader.getClass().getName().startsWith("com.ibm")) {
            try {
                Enumeration<URL> urls = this.classLoader.getResources(location.getRootPath() + "/flyway.location");
                if (!urls.hasMoreElements()) {
                    LOG.error("Unable to resolve location " + String.valueOf(location) + " (ClassLoader: " + String.valueOf(this.classLoader) + ") On WebSphere an empty file named flyway.location must be present on the classpath location for WebSphere to find it!");
                }
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    locationUrls.add(new URL(UrlUtils.decodeURL(url.toExternalForm()).replace("/flyway.location", "")));
                }
            }
            catch (IOException e) {
                LOG.error("Unable to resolve location " + String.valueOf(location) + " (ClassLoader: " + String.valueOf(this.classLoader) + ") On WebSphere an empty file named flyway.location must be present on the classpath location for WebSphere to find it!");
            }
        } else {
            try {
                Enumeration<URL> urls = this.classLoader.getResources(location.getRootPath());
                while (urls.hasMoreElements()) {
                    locationUrls.add(urls.nextElement());
                }
            }
            catch (IOException e) {
                LOG.error("Unable to resolve location " + String.valueOf(location) + " (ClassLoader: " + String.valueOf(this.classLoader) + "): " + e.getMessage() + ".");
            }
        }
        this.locationUrlCache.put(location, locationUrls);
        return locationUrls;
    }

    private UrlResolver createUrlResolver(String protocol) {
        if (protocol.startsWith("vfs") && new FeatureDetector(this.classLoader).isJBossVFSv2Available()) {
            return new JBossVFSv2UrlResolver();
        }
        return new DefaultUrlResolver();
    }

    private ClassPathLocationScanner createLocationScanner(String protocol) {
        if (this.locationScannerCache.containsKey(protocol)) {
            return this.locationScannerCache.get(protocol);
        }
        if ("file".equals(protocol)) {
            FileSystemClassPathLocationScanner locationScanner = new FileSystemClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        if ("jar".equals(protocol) || this.isTomcat(protocol) || this.isWebLogic(protocol) || this.isWebSphere(protocol)) {
            String separator = this.isTomcat(protocol) ? "*/" : "!/";
            JarFileClassPathLocationScanner locationScanner = new JarFileClassPathLocationScanner(separator);
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        FeatureDetector featureDetector = new FeatureDetector(this.classLoader);
        if ("vfs".equals(protocol) && featureDetector.isJBossVFSv3Available()) {
            JBossVFSv3ClassPathLocationScanner locationScanner = new JBossVFSv3ClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        if ((this.isFelix(protocol) || this.isEquinox(protocol)) && featureDetector.isOsgiFrameworkAvailable()) {
            OsgiClassPathLocationScanner locationScanner = new OsgiClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap<URL, Set<String>>());
            return locationScanner;
        }
        return null;
    }

    private boolean isEquinox(String protocol) {
        return "bundleresource".equals(protocol);
    }

    private boolean isFelix(String protocol) {
        return "bundle".equals(protocol);
    }

    private boolean isWebSphere(String protocol) {
        return "wsjar".equals(protocol);
    }

    private boolean isWebLogic(String protocol) {
        return "zip".equals(protocol);
    }

    private boolean isTomcat(String protocol) {
        return "war".equals(protocol);
    }
}

