/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.util.regex.Pattern;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class MySQLSqlStatementBuilder
extends SqlStatementBuilder {
    private static final String DELIMITER_KEYWORD = "DELIMITER";
    private static final String[] CHARSETS = new String[]{"ARMSCII8", "ASCII", "BIG5", "BINARY", "CP1250", "CP1251", "CP1256", "CP1257", "CP850", "CP852", "CP866", "CP932", "DEC8", "EUCJPMS", "EUCKR", "GB2312", "GBK", "GEOSTD8", "GREEK", "HEBREW", "HP8", "KEYBCS2", "KOI8R", "KOI8U", "LATIN1", "LATIN2", "LATIN5", "LATIN7", "MACCE", "MACROMAN", "SJIS", "SWE7", "TIS620", "UCS2", "UJIS", "UTF8", "UTF8MB4"};
    boolean isInMultiLineCommentDirective = false;

    public MySQLSqlStatementBuilder() {
        super(Delimiter.SEMICOLON);
    }

    @Override
    public Delimiter extractNewDelimiterFromLine(String line) {
        if (!this.insideMultiLineComment && !this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return null;
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return delimiter;
    }

    @Override
    public boolean isCommentDirective(String line) {
        if (line.matches("^" + Pattern.quote("/*!") + "\\d{5} .*" + Pattern.quote("*/") + "\\s*;?")) {
            return true;
        }
        if (line.matches("^" + Pattern.quote("/*!") + "\\d{5} .*")) {
            this.isInMultiLineCommentDirective = true;
            return true;
        }
        if (this.isInMultiLineCommentDirective && line.matches(".*" + Pattern.quote("*/") + "\\s*;?")) {
            this.isInMultiLineCommentDirective = false;
            return true;
        }
        return this.isInMultiLineCommentDirective;
    }

    @Override
    protected boolean isSingleLineComment(String token) {
        return token.startsWith("--") || token.startsWith("#") && (!"#".equals(this.delimiter.getDelimiter()) || !"#".equals(token));
    }

    @Override
    protected String removeEscapedQuotes(String token) {
        String noEscapedBackslashes = StringUtils.replaceAll(token, "\\\\", "");
        String noBackslashEscapes = StringUtils.replaceAll(StringUtils.replaceAll(noEscapedBackslashes, "\\'", ""), "\\\"", "");
        return StringUtils.replaceAll(noBackslashEscapes, "''", "").replace("'", " ' ");
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("B'") || token.startsWith("X'")) {
            return token.substring(token.indexOf("'"));
        }
        if (token.startsWith("_")) {
            for (String charSet : CHARSETS) {
                String cast = "_" + charSet;
                if (!token.startsWith(cast)) continue;
                return token.substring(cast.length());
            }
        }
        return token;
    }

    @Override
    protected String extractAlternateOpenQuote(String token) {
        if (token.startsWith("\"")) {
            return "\"";
        }
        return null;
    }
}

